import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.io.*;


class MotionCanvas extends ScaleCanvas implements MouseListener, MouseMotionListener {
    Manager M;
    double h,w;
    Polyvector P;
    Vector v;
    Vector CENTER;
    long CENTERCOUNT;
    Vector[] PLOT=new Vector[100000];
    Vector[] CIRC=new Vector[3];
    Vector[] DUMMY=new Vector[100000];
 

    int COUNT=0;
    Vector SOURCE;
    double time;
    int number;

    MotionCanvas() {
	addMouseListener(this);
	addMouseMotionListener(this);
	setScales(300,300,300);
	initialize();;
    }

    public void initialize() {
        w=1.0/2;
	h=1.0/3;
	number=6;
	v=new Vector(0,1,1);
	P=new Polyvector(number);
	P=P.entail(v,number,w,h);
	SOURCE=new Vector(0,0,1);
	CIRC[0]=new Vector(0,0,1);
	CIRC[1]=new Vector(0,0,1);
	CIRC[2]=new Vector(0,0,1);
    }


    public void paint(Graphics gfx) {
      Graphics2D g=(Graphics2D) gfx;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                         RenderingHints.VALUE_ANTIALIAS_ON);

      drawbgAndOuter(g);
      drawPoly(g);
      drawInner(g);
      drawPlot(g);
    }


    public Path2D.Double makeEllipse(double width,double height,Vector V) {
	double x=V.x;
	double y=V.y;
	double d=Math.sqrt(x*x+y*y);
	Matrix m1=Matrix.translate(d);
	double c0=1;
	double s0=0;
	if(d>.000001) {
	    c0=x/d;
	    s0=-y/d;
	}
	Matrix m2=Matrix.rotate(c0,s0);
	Matrix m3=Matrix.rotate(c0,-s0);
	Path2D.Double gp=new Path2D.Double();
	for(int i=0;i<1000;++i) {
	    double c=width*Math.cos(Math.PI*2.0*i/1000);
	    double s=height*Math.sin(Math.PI*2.0*i/1000);
	    Vector v=new Vector(c,s,1);
	    v=m3.act(v);
	    v=m1.act(v);
	    v=m2.act(v);
	    c=v.x;
	    s=v.y;
	    if(i==0) gp.moveTo(c,s);
	    if(i!=0) gp.lineTo(c,s);
	}
	return(gp);
    }

    public void export() {
	Color[] C=new Color[8];
	for(int i=0;i<8;++i) C[i]=M.C.DISPLAY.M[i].C;
	Output OUT=new Output("Output/graph");
	Path2D.Double gp=makeEllipse(1,1,new Vector(0,0,1));
	OUT.polyWrite(gp,C[1],C[2]);
	Polyvector PP=Matrix.specialTransform(P,SOURCE);
        gp=PP.toPath();
	OUT.polyWrite(gp,C[5],C[6]);
	gp=makeEllipse(w,h,SOURCE);
	OUT.polyWrite(gp,C[3],C[4]);

	for(int i=0;i<COUNT-1;++i) {
	    Complex z1=new Complex(PLOT[i+0].x,PLOT[i+0].y);
	    Complex z2=new Complex(PLOT[i+1].x,PLOT[i+1].y);
	    OUT.segmentWrite(z1.x,z1.y,z2.x,z2.y,C[7]);
	}
    }

    public void drawbgAndOuter(Graphics2D g) {
	g.setColor(M.C.DISPLAY.M[0].C);
	g.fillRect(0,0,getWidth(),getHeight());	
	Path2D.Double gp=makeEllipse(1,1,new Vector(0,0,1));
        gp=transform(gp);
	g.setColor(M.C.DISPLAY.M[1].C);
	g.fill(gp);
	g.setColor(M.C.DISPLAY.M[2].C);
	g.draw(gp);
    }

    public void drawInner(Graphics2D g) {
	Path2D.Double gp=makeEllipse(w,h,SOURCE);
	gp=transform(gp);
	g.setColor(M.C.DISPLAY.M[3].C);
	g.fill(gp);
	g.setColor(M.C.DISPLAY.M[4].C);
	g.draw(gp);
    }

    public void drawPoly(Graphics2D g) { 
	Polyvector PP=Matrix.specialTransform(P,SOURCE);
	Path2D.Double gp=PP.toPath();
	gp=transform(gp);
        g.setColor(M.C.DISPLAY.M[5].C);
	g.fill(gp);
        g.setColor(M.C.DISPLAY.M[6].C);
	g.draw(gp);
    }


    public void drawPlot(Graphics2D g) { 
	for(int i=0;i<COUNT;++i) {
	    Complex z=new Complex(PLOT[i].x,PLOT[i].y);
            fillPoint(g,z,.000001,M.C.DISPLAY.M[7].C,16);
	}
    }

    void evolve(double t) {
	double x1=-v.y;
	double y1=v.x;
	double x2=v.x+t*x1;
	double y2=v.y+t*y1;
	double d=Math.sqrt(x2*x2+y2*y2);
	v.x=x2/d;
	v.y=y2/d;
        P=P.entail(v,number,w,h);
	v=P.v[2];
	relax();
    }


    void relax() { 
	double d=P.closingDistance();
	if(P.crossTest()==1) {
	    w=w*(1+d/10000);
	    h=h*(1+d/10000);
	}
	if(P.crossTest()==0) {
	    w=w*(1-d/10000);
	    h=h*(1-d/10000);
	}
    }

    public void addPlot() {
	int choice=M.C.TEST.val;
	double LIM=Math.pow(2,M.C.PLOT.val);
	double tol=Math.pow(.5,M.C.SENSE.val+10);
	Polyvector PP=Matrix.specialTransform(P,SOURCE);
	Vector V=PP.CM(choice);

	CIRC[2]=new Vector(CIRC[1]);
	CIRC[1]=new Vector(CIRC[0]);
	CIRC[0]=new Vector(V);



	boolean test=false;
	for(int i=0;i<COUNT;++i) {
	    double d=V.dist(PLOT[i]);
	    if(d<tol) test=true;
	}
	if(COUNT==LIM) test=true;
	if(test==false) {
   	    PLOT[COUNT]=new Vector(V.x,V.y,1);
   	    DUMMY[COUNT]=new Vector(v.x,v.y,1);
	    ++COUNT;
	}

    }


    public int random(int n) {
	double d=Math.random();
	int x=(int)(d*n);
	return(x);
    }


 public void mouseExited(MouseEvent e) {
 }



 public void mouseReleased(MouseEvent e) {}
 public void mousePressed(MouseEvent e) {}
 public void mouseEntered(MouseEvent e) {
 }

 public void mouseMoved(MouseEvent e) {}


 public void mouseClicked(MouseEvent e) {
   MouseData J=MouseData.process(e);
   int mode=getMode(J);
   if(mode!=2)  scaleUp(J.X,mode);
    if(mode==2) {
	Complex z=unTransform(J.X);
	SOURCE=new Vector(z.x,z.y,1);
    }
    repaint();
 }

 public void mouseDragged(MouseEvent e) {
   MouseData J=MouseData.process(e);
     int mode=getMode(J);
    if(mode==2) {
	Complex z=unTransform(J.X);
	SOURCE=new Vector(z.x,z.y,1);
    }
    repaint();
 }

    public int getMode(MouseData J) {
	int m=M.C.MOUSE.val;
	if(m==0) return(J.mode);
	return(m);
    }

}



