import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.io.*;


class Polyvector {
    int n;
    Vector[] v=new Vector[50];

    Polyvector(int S) {
	this.n=S;
	for(int i=1;i<=S;++i) v[i]=new Vector();
    }


    Polyvector entail(Vector v,int n,double w,double h) {
	Polyvector P=new Polyvector(n);
	P.v[1]=v;
	for(int i=1;i<n;++i) {
	    P.v[i+1]=P.v[i].next(w,h);
	}
	P.v[n+1]=P.v[1];
	P.v[n+2]=P.v[2];
	P.n=n;
	return(P);
    }

    public Path2D.Double toPath() {
	Path2D.Double gp=new Path2D.Double(Path2D.WIND_EVEN_ODD);
	gp.moveTo((float)(v[1].x),(float)(v[1].y));
	for(int i=2;i<=n;++i) {
	   gp.lineTo((float)(v[i].x),(float)(v[i].y));
	}
	gp.closePath();
	return(gp);
    }

    int crossTest() {
	Vector v1=v[1];
	Vector v2=v[2];
	Vector v3=v[n-1];
	Vector v4=v[n];
	Vector w=v1.cross(v1.cross(v1,v2),v1.cross(v3,v4));
	w=w.normalize();
	int test=0;
	if((w.x>v1.x)&&(w.x<v2.x)) test=1;
        if((w.x<v1.x)&&(w.x>v2.x)) test=1;
	return(test);
    }

    double closingDistance() {
	Vector v1=v[1];
	Vector v2=v[n];
	double d=(v1.x-v2.x)*(v1.x-v2.x);
	d=d+(v1.y-v2.y)*(v1.y-v2.y);
	d=Math.sqrt(d);
	return(d);
    }

    /**center of mass routines*/

    public Vector CM(int choice) {
	if(choice==0) return(vtxCM());
	if(choice==1) return(edgCM());
	if(choice==2) return(facCM());
	if(choice==3) return(sym2CM());
	if(choice==4) return(sym3CM());
	return(sym4CM());
    }

    public Vector vtxCM() {

	Vector V=new Vector(0,0,0);
	for(int i=1;i<n;++i) {
	    Vector W=this.v[i].normalize();
	    V=V.plus(W);
	}
	V.x=V.x/(n-1);
	V.y=V.y/(n-1);
	V.z=1;
	return(V);
    }

    public Vector edgCM() {
	Vector V=new Vector(0,0,0);
	double D=0;
	for(int i=1;i<n;++i) {
	    int j=i+1;
	    if(j==n) j=1;
	    Vector V1=this.v[i].normalize();
	    Vector V2=this.v[j].normalize();
	    Vector V3=V2.plus(V1);  
            double d=V1.dist(V2);
	    D=D+d;
	    V3=new Vector(d*V3.x/2,d*V3.y/2,1);
	    V=V.plus(V3);
	}
	V.x=V.x/D;
	V.y=V.y/D;
	V.z=1;
	return(V);
    }



    public Vector sym2CM() {
	Complex z=new Complex(0,0);

	for(int i=1;i<n;++i) {
	    for(int j=i+1;j<n;++j){
	    Vector V1=this.v[i].normalize();
	    Vector V2=this.v[j].normalize();
	    Complex z1=new Complex(V1.x,V1.y);
	    Complex z2=new Complex(V2.x,V2.y);
	    z=Complex.plus(z,Complex.times(z1,z2));
	    }
	}   
        double D=n*(n+1)/2;
	Vector V=new Vector(z.x/D,z.y/D,1);
	return(V);
    }


    public Vector sym3CM() {
	Complex z=new Complex(0,0);

	for(int i=1;i<n;++i) {
	    for(int j=i+1;j<n;++j){
	      for(int k=j+1;k<n;++k){
	    Vector V1=this.v[i].normalize();
	    Vector V2=this.v[j].normalize();
	    Vector V3=this.v[k].normalize();
	    Complex z1=new Complex(V1.x,V1.y);
	    Complex z2=new Complex(V2.x,V2.y);
	    Complex z3=new Complex(V3.x,V3.y);
	    z=Complex.plus(z,Complex.times(z1,Complex.times(z2,z3)));
	      }
	    }
	}
	Vector V=new Vector(z.x,z.y,1);
	return(V);
    }



    public Vector sym4CM() {
	Complex z=new Complex(0,0);

	for(int i=1;i<n;++i) {
	    for(int j=i+1;j<n;++j){
	      for(int k=j+1;k<n;++k){
	        for(int l=k+1;l<n;++l){
	          Vector V1=this.v[i].normalize();
	          Vector V2=this.v[j].normalize();
	          Vector V3=this.v[k].normalize();
	          Vector V4=this.v[l].normalize();
	          Complex z1=new Complex(V1.x,V1.y);
	          Complex z2=new Complex(V2.x,V2.y);
	          Complex z3=new Complex(V3.x,V3.y);
	          Complex z4=new Complex(V4.x,V4.y);
	          z=Complex.plus(z,Complex.times(z1,Complex.times(z2,Complex.times(z3,z4))));
		}
	      }
	    }
	}
	Vector V=new Vector(z.x,z.y,1);
	return(V);
    }





    public Vector facCM() {
	Vector V=new Vector(0,0,0);
	double D=0;
	for(int i=1;i<n-2;++i) {
	    int j=i+1;
	    int k=i+2;
            Vector V1=this.v[1].normalize();
	    Vector V2=this.v[j].normalize();
	    Vector V3=this.v[k].normalize();
	    Vector V4=V3.plus(V2.plus(V1));
	    double d=V4.tripleProduct(V1,V2,V3);
	    //d=Math.abs(d);
	    D=D+d;
            V4=new Vector(d*V4.x/6,d*V4.y/6,1);
	    V=V.plus(V4);
	}
	V.x=2*V.x/D;
	V.y=2*V.y/D;
	V.z=1;
	return(V);
    }






    /**print*/
    public void print() {
	System.out.println("polygon");
	for(int i=1;i<=n;++i) {
	    this.v[i].print();
	}
    }

}



