import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.io.*;


class Vector {
    double x,y,z;

    public void print() {
	System.out.println(x+"  "+y+"  "+z);
    }

    Vector() {
	this.x=0;
	this.y=0;
	this.z=0;
    }

    Vector(Vector V) {
	this.x=V.x;
	this.y=V.y;
	this.z=V.z;
    }

    Vector(double x,double y,double z) {
	this.x=x;
	this.y=y;
	this.z=z;
    }

    Vector plus(Vector V) {
	Vector W=new Vector(V.x+this.x,V.y+this.y,V.z+this.z);
	return(W);
    }


    Vector minus(Vector V) {
	Vector W=new Vector(V.x-this.x,V.y-this.y,V.z-this.z);
	return(W);
    }

    Vector cross(Vector V,Vector W) {
	Vector X=new Vector();
	X.x=V.y*W.z-V.z*W.y;
        X.y=V.z*W.x-V.x*W.z;
        X.z=V.x*W.y-V.y*W.x;
	return(X);
    }


    double dot(Vector V,Vector W) {
	return(V.x*W.x+V.y*W.y+V.z*W.z);
    }

    double dist(Vector V) {
	Vector X=this.minus(V);
	double d=dot(X,X);
	return(Math.sqrt(d));
    }

    double tripleProduct(Vector V,Vector W,Vector X) {
	double d=dot(V,cross(W,X));
	return(d);
    }

    Vector normalize() {
	Vector X=this;
	X.x=x/z;
	X.y=y/z;
	X.z=1;
	return(X);
    }

    Vector next(double w,double h) {
	Vector W=new Vector();
	double x1=this.x/this.z;
	double y1=this.y/this.z;
	double c=(x1/w)*(x1/w)+(y1/h)*(y1/h);
	double t=Math.sqrt(c-1);
	double x2=(w*t*y1/h+x1)/c;
	double y2=(y1-h*t*x1/w)/c;
	double vx=y2-y1;
	double vy=x1-x2;
	double d=Math.sqrt(vx*vx+vy*vy);
	double ux=vx/d;
	double uy=vy/d;
	d=x1*ux+y1*uy;
	W.x=-x1+2*d*ux;
        W.y=-y1+2*d*uy;
	W.z=1;
	return(W);
    }

    void render(Graphics g,Color C) {
	int xx=(int)(this.x/this.z);
	int yy=(int)(this.y/this.z);
	g.setColor(C);
	g.fillOval(75+xx-5,75+yy-5,10,10);
    }

    void render(Vector v,Graphics g,Color C) {
	int x1=(int)(this.x/this.z);
	int y1=(int)(this.y/this.z);
        int x2=(int)(v.x/v.z);
	int y2=(int)(v.y/v.z);
	g.setColor(C);
	g.drawLine(75+x1,75+y1,75+x2,75+y2);
    }



}
