import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;


public class XInvariants {
    double x,y;
    
    public XInvariants() {}

    //vectors should be normalized to have 3rd coordinate equal to 1.

    public static double slope(Vector V1,Vector V2) {
        double s;
        s=(V2.y-V1.y)/(V2.x-V1.x);
        return(s);
    }


    //inverse of usual cross ratio
    public static double cross0(double a,double b,double c,double d)
      {
      double x;
      x=(a-b)*(c-d)/((a-c)*(b-d));
      return(x);
      }


    public static double fan(Vector x,Vector a,Vector b,Vector c,Vector d) {
        double f=cross0(slope(x,a),slope(x,b),slope(x,c),slope(x,d));
        return(f);
    }



    // the local invariant
    public static double locinv(Polyvector P,int j,int ii) {
        int i;
	int n=P.n;
	int j1=(j-1*ii+n)%n;
	int j2=(j-2*ii+n)%n;
	int j3=(j-0*ii+n)%n;
	int j4=(j+1*ii+n)%n;
	int j5=(j+2*ii+n)%n;
	double ll=fan(P.v[j1],P.v[j2],P.v[j3],P.v[j4],P.v[j5]);
        return(ll);
    }


    // the global invariants

    public static double[] invariant(Polyvector P) {
	double[] x=new double[P.n*2];

        for(int i=0;i<P.n;++i) {
             x[2*i-0]=locinv(P,i,-1);
             x[2*i+1]=locinv(P,i,1);
	}
	return(x);
    }

    public static double conicInvariant(Polyvector P) {
	double[] x=invariant(P);
	return (1-x[0])*x[1]*(1-x[2]);
    }

    public static Polyvector cleanOff(Polyvector P) {
	Polyvector Q=new Polyvector(P.n-1);
	Q.n=P.n-1;
	for(int i=0;i<Q.n;++i) Q.v[i]=new Vector(P.v[i+1]);
	return(Q);
    }



}


