import java.awt.event.*;
import java.awt.*;
import java.math.BigInteger;

public class Separation {


    /**This is the big test.  We do it for 120 = 24 + 72 + 24 vectors.
       This returns the separation gap in each case.*/
    

    public static BigInteger mainTest(int choice,int k) {
	VectorBig L=separatingVector(choice,k);
	return gap(choice,k,L);
    }



    /**This tests whether there is a separating gap using the vector L.
       If so, then "dot with L" is a linear function that separates the
       two triangles.  In this case, we return the size of the gap. Otherwise
       we return -1*/


    public static BigInteger gap(int choice,int k,VectorBig L) {
	BigInteger[][] d=LF(choice,k,L);
	BigInteger[] d0=d[0];
	BigInteger[] d1=d[1];
	BigInteger d0Min=d0[0].min(d0[1]);
	BigInteger d0Max=d0[0].max(d0[1]);
	BigInteger d1Min=d1[0].min(d1[1]);
	BigInteger d1Max=d1[0].max(d1[1]);
	if(d0Max.compareTo(d1Min)<0) return(d1Min.subtract(d0Max));
	if(d1Max.compareTo(d0Min)<0) return(d0Min.subtract(d1Max));
	return new BigInteger("-1");
    }
    

    /**This routine applies the linear functional (based on the vector L) to
       each of the vertices in the given triangle pair and reports on the
       min and max value in each case*/
    
    public static BigInteger[][] LF(int choice,int k,VectorBig L) {
        BigInteger googol0 = BigInteger.TEN.pow(100);
	BigInteger googol1 = googol0.negate();
	BigInteger[] d0={googol0,googol1};
	BigInteger[] d1={googol0,googol1};
	VectorBig[] T0=triangle(choice,k,0);
        VectorBig[] T1=triangle(choice,k,1);
	
	for(int i=choice;i<3;++i) {
	    BigInteger test=VectorBig.dot(L,T0[i]);
	    d0[0]=d0[0].min(test);
	    d0[1]=d0[1].max(test);
	}

	for(int i=choice;i<3;++i) {
	    BigInteger test=VectorBig.dot(L,T1[i]);
	    d1[0]=d1[0].min(test);
	    d1[1]=d1[1].max(test);
	}
	BigInteger[][] d={d0,d1};
	return d;
    }



    /**This gets the separating vector to use in the main test above*/

    /**This gets the triangle pairs to test*/
    public static VectorBig separatingVector(int choice,int k) {
	VectorBig[] V=VEC(choice);
	return V[k];
    }

    public static VectorBig[] VEC(int choice) {
	if(choice==0) return EmbeddedProof0.L();
	if(choice==1) return EmbeddedProof1.L();
	if(choice==2) return EmbeddedProof2.L();
	return null;
    }
    

    

    /**This gets the triangle pairs to test*/
    public static VectorBig[] triangle(int choice,int k,int q) {
	int[][][] D=TRI(choice);
	VectorBig[] V=IntegerTorus.main();
	int[][] E=D[k];
	int[] f=E[q];
	ListHelp.printout(f);
	VectorBig[] A={V[f[0]],V[f[1]],V[f[2]]};
	return A;
    }

    /**Here are the lists of pairs of triangle faces */
    
    public static int[][][] TRI(int choice) {
	if(choice==0) return D0();
	if(choice==1) return D1();
	if(choice==2) return D2();
	return null;
    }

    /**pairs which share no vertices*/

public static int[][][] D0() {
    return new int[][][] {
        {{0,1,2}, {3,4,6}},  // 0,13
        {{0,1,2}, {3,5,7}},  // 0,14
        {{0,1,2}, {3,6,7}},  // 0,15
        {{0,1,3}, {2,4,7}},  // 1,10
        {{0,1,3}, {2,5,6}},  // 1,11
        {{0,1,3}, {2,6,7}},  // 1,12
        {{0,2,4}, {1,5,7}},  // 2,9
        {{0,2,4}, {3,5,7}},  // 2,14
        {{0,2,4}, {3,6,7}},  // 2,15
        {{0,3,5}, {1,4,7}},  // 3,8
        {{0,3,5}, {2,4,7}},  // 3,10
        {{0,3,5}, {2,6,7}},  // 3,12
        {{0,4,6}, {1,2,5}},  // 4,6
        {{0,4,6}, {1,5,7}},  // 4,9
        {{0,4,6}, {3,5,7}},  // 4,14
        {{0,5,6}, {1,3,4}},  // 5,7
        {{0,5,6}, {1,4,7}},  // 5,8
        {{0,5,6}, {2,4,7}},  // 5,10
        {{1,2,5}, {3,4,6}},  // 6,13
        {{1,2,5}, {3,6,7}},  // 6,15
        {{1,3,4}, {2,5,6}},  // 7,11
        {{1,3,4}, {2,6,7}},  // 7,12
        {{1,4,7}, {2,5,6}},  // 8,11
        {{1,5,7}, {3,4,6}}   // 9,13
    };
}


    /**pairs which share one vertex*/
    
public static int[][][] D1() {
    return new int[][][] {
        { { 0,1,2 }, { 0,3,5 } },
        { { 0,1,2 }, { 0,4,6 } },
        { { 0,1,2 }, { 0,5,6 } },
        { { 0,1,3 }, { 0,2,4 } },
        { { 0,1,3 }, { 0,4,6 } },
        { { 0,1,3 }, { 0,5,6 } },
        { { 0,2,4 }, { 0,3,5 } },
        { { 0,2,4 }, { 0,5,6 } },
        { { 0,3,5 }, { 0,4,6 } },
        { { 1,2,0 }, { 1,3,4 } },
        { { 1,2,0 }, { 1,4,7 } },
        { { 1,2,0 }, { 1,5,7 } },
        { { 1,3,0 }, { 1,2,5 } },
        { { 1,3,0 }, { 1,4,7 } },
        { { 1,3,0 }, { 1,5,7 } },
        { { 1,2,5 }, { 1,3,4 } },
        { { 1,2,5 }, { 1,4,7 } },
        { { 1,3,4 }, { 1,5,7 } },
        { { 2,0,1 }, { 2,4,7 } },
        { { 2,0,1 }, { 2,5,6 } },
        { { 2,0,1 }, { 2,6,7 } },
        { { 2,4,0 }, { 2,5,1 } },
        { { 2,4,0 }, { 2,5,6 } },
        { { 2,4,0 }, { 2,6,7 } },
        { { 2,5,1 }, { 2,4,7 } },
        { { 2,5,1 }, { 2,6,7 } },
        { { 2,4,7 }, { 2,5,6 } },
        { { 3,0,1 }, { 3,4,6 } },
        { { 3,0,1 }, { 3,5,7 } },
        { { 3,0,1 }, { 3,6,7 } },
        { { 3,5,0 }, { 3,4,1 } },
        { { 3,5,0 }, { 3,4,6 } },
        { { 3,5,0 }, { 3,6,7 } },
        { { 3,4,1 }, { 3,5,7 } },
        { { 3,4,1 }, { 3,6,7 } },
        { { 3,4,6 }, { 3,5,7 } },
        { { 4,0,2 }, { 4,1,3 } },
        { { 4,0,2 }, { 4,7,1 } },
        { { 4,0,2 }, { 4,6,3 } },
        { { 4,6,0 }, { 4,1,3 } },
        { { 4,6,0 }, { 4,7,1 } },
        { { 4,6,0 }, { 4,7,2 } },
        { { 4,1,3 }, { 4,7,2 } },
        { { 4,7,1 }, { 4,6,3 } },
        { { 4,7,2 }, { 4,6,3 } },
        { { 5,0,3 }, { 5,1,2 } },
        { { 5,0,3 }, { 5,7,1 } },
        { { 5,0,3 }, { 5,6,2 } },
        { { 5,6,0 }, { 5,1,2 } },
        { { 5,6,0 }, { 5,7,1 } },
        { { 5,6,0 }, { 5,7,3 } },
        { { 5,1,2 }, { 5,7,3 } },
        { { 5,7,1 }, { 5,6,2 } },
        { { 5,6,2 }, { 5,7,3 } },
        { { 6,0,4 }, { 6,2,5 } },
        { { 6,0,4 }, { 6,7,2 } },
        { { 6,0,4 }, { 6,7,3 } },
        { { 6,0,5 }, { 6,7,2 } },
        { { 6,0,5 }, { 6,3,4 } },
        { { 6,0,5 }, { 6,7,3 } },
        { { 6,2,5 }, { 6,3,4 } },
        { { 6,2,5 }, { 6,7,3 } },
        { { 6,7,2 }, { 6,3,4 } },
        { { 7,1,4 }, { 7,2,6 } },
        { { 7,1,4 }, { 7,3,5 } },
        { { 7,1,4 }, { 7,3,6 } },
        { { 7,1,5 }, { 7,2,4 } },
        { { 7,1,5 }, { 7,2,6 } },
        { { 7,1,5 }, { 7,3,6 } },
        { { 7,2,4 }, { 7,3,5 } },
        { { 7,2,4 }, { 7,3,6 } },
        { { 7,2,6 }, { 7,3,5 } },
    };
}

    /**pairs which share 2 vertices*/
    
public static int[][][] D2() {
    return new int[][][] {
        { { 0,1,2 }, { 0,1,3 } },
        { { 0,2,1 }, { 0,2,4 } },
        { { 0,3,1 }, { 0,3,5 } },
        { { 0,4,2 }, { 0,4,6 } },
        { { 0,5,3 }, { 0,5,6 } },
        { { 0,6,4 }, { 0,6,5 } },
        { { 1,2,0 }, { 1,2,5 } },
        { { 1,3,0 }, { 1,3,4 } },
        { { 1,5,2 }, { 1,5,7 } },
        { { 1,4,3 }, { 1,4,7 } },
        { { 1,7,4 }, { 1,7,5 } },
        { { 2,4,0 }, { 2,4,7 } },
        { { 2,5,1 }, { 2,5,6 } },
        { { 2,7,4 }, { 2,7,6 } },
        { { 2,6,5 }, { 2,6,7 } },
        { { 3,5,0 }, { 3,5,7 } },
        { { 3,4,1 }, { 3,4,6 } },
        { { 3,6,4 }, { 3,6,7 } },
        { { 3,7,5 }, { 3,7,6 } },
        { { 4,6,0 }, { 4,6,3 } },
        { { 4,7,1 }, { 4,7,2 } },
        { { 5,6,0 }, { 5,6,2 } },
        { { 5,7,1 }, { 5,7,3 } },
        { { 6,7,2 }, { 6,7,3 } },
    };
}



    
    
}



