import java.awt.event.*;
import java.awt.*;
import java.math.*;


public class NearFlat {


    /*The combinaatorial edges*/ 
    public static int[] edgeLink(int link) {
int[][] l = {{1,2,4,6,5,3},
        {2,0,3,4,7,5},
        {0,1,5,6,7,4},
        {5,7,6,4,1,0},
        {0,2,7,1,3,6},
        {6,2,1,7,3,0},
        {0,4,3,7,2,5},
	{1,4,2,6,3,5}};
    return l[link];
    }
    
    
    /*choice is the link choice and k is the triangle within the link*/
    
    public static VectorBig[] planeTriangle(int choice,int k) {
	String[][][] S=new String[6][3][2];
	if(choice==0) S=LinkData.data0;
	if(choice==1) S=LinkData.data1;
	if(choice==2) S=LinkData.data2;
	if(choice==3) S=LinkData.data3;
	if(choice==4) S=LinkData.data4;
	if(choice==5) S=LinkData.data5;
	if(choice==6) S=LinkData.data6;
	if(choice==7) S=LinkData.data7;
	String ZERO="0";
	String[][] T=S[k];
	VectorBig[] a=new VectorBig[3];
	for(int i=0;i<3;++i) {
	    a[i]=new VectorBig(T[i][0],T[i][1],ZERO);
	}
	return a;
    }

    public static VectorBig[] spaceTriangle(int choice,int k) {
	int[] L=edgeLink(choice);
	int k0=k;
	int k1=(k+1)%6;
	VectorBig[] T=IntegerTorus.main();
	VectorBig[] V={T[choice],T[L[k0]],T[L[k1]]};
	return V;
    }


    public static BigInteger[] dotProducts(VectorBig[] a) {
	VectorBig va1=VectorBig.minus(a[1],a[0]);
	VectorBig va2=VectorBig.minus(a[2],a[0]);
	BigInteger a12=VectorBig.dot(va1,va2);
	BigInteger a11=VectorBig.dot(va1,va1);
	BigInteger a22=VectorBig.dot(va2,va2);
	BigInteger a1212=a12.multiply(a12);
	BigInteger a1122=a11.multiply(a22);
	BigInteger[] d={a1212,a1122};
	return d;
    }




    
    public static BigDecimal ratio(BigInteger[] a,int PRECISION) {
	MathContext mc=new MathContext(PRECISION);
	BigDecimal b0=new BigDecimal(a[0].toString());
	BigDecimal b1=new BigDecimal(a[1].toString());
	BigDecimal b=b0.divide(b1,mc);
	return b;
    }


    /**Here is the decimal comparison. This needs the AcosBig and SqrtBig files to run. 
       We don't need this here but we keep it around just in case

    public static BigDecimal compareAngles(int choice,int k,int PRECISION) {
	MathContext mc=new MathContext(PRECISION);
	VectorBig[] a=NearFlat.planeTriangle(choice,k);
	VectorBig[] b=NearFlat.spaceTriangle(choice,k);
	BigInteger[] da=dotProducts(a);
	BigInteger[] db=dotProducts(b);
	BigDecimal aa=ratio(da,PRECISION);
	BigDecimal bb=ratio(db,PRECISION);
	aa=SqrtBig.sqrt(aa,PRECISION);
       	aa=AcosBig.acos(aa,PRECISION);
	bb=SqrtBig.sqrt(bb,PRECISION);
	bb=AcosBig.acos(bb,PRECISION);
	BigDecimal c=aa.subtract(bb).abs();
	return c;
    }
    */

    public static BigDecimal compareDotProductRatios(int choice,int k,int PRECISION) {
	MathContext mc=new MathContext(PRECISION);
	VectorBig[] a=NearFlat.planeTriangle(choice,k);
	VectorBig[] b=NearFlat.spaceTriangle(choice,k);
	BigInteger[] da=dotProducts(a);
	BigInteger[] db=dotProducts(b);
	BigDecimal aa=ratio(da,PRECISION);
	BigDecimal bb=ratio(db,PRECISION);
	BigDecimal c=aa.subtract(bb).abs();
	return c;
    }




    
    public static BigDecimal dotProductRatioMin(int choice,int k,int PRECISION) {
	MathContext mc=new MathContext(PRECISION);
	VectorBig[] a=NearFlat.planeTriangle(choice,k);
	VectorBig[] b=NearFlat.spaceTriangle(choice,k);
	BigInteger[] da=dotProducts(a);
	BigInteger[] db=dotProducts(b);
	BigDecimal aa=ratio(da,PRECISION);
	BigDecimal bb=ratio(db,PRECISION);
	aa=aa.abs();
	bb=bb.abs();
	BigDecimal c=aa.min(bb);
	return c;
    }

    public static BigDecimal dotProductRatioMax(int choice,int k,int PRECISION) {
	MathContext mc=new MathContext(PRECISION);
	VectorBig[] a=NearFlat.planeTriangle(choice,k);
	VectorBig[] b=NearFlat.spaceTriangle(choice,k);
	BigInteger[] da=dotProducts(a);
	BigInteger[] db=dotProducts(b);
	BigDecimal aa=ratio(da,PRECISION);
	BigDecimal bb=ratio(db,PRECISION);
	aa=aa.abs();
	bb=bb.abs();
	BigDecimal c=aa.max(bb);
	return c;
    }

}

