
import java.awt.event.*;
import java.awt.*;
import java.math.*;

/*This class does the basic arithmetic
  of high precision complex numbers */

public class ComplexBig {
   public  BigDecimal x,y;
    int label;
    
    public ComplexBig() {
        this.x=new BigDecimal(0);
        this.y=new BigDecimal(0);
    } 
    
    /** Create the complex number x+i*y */
    public ComplexBig(BigDecimal x,BigDecimal y) {
        this.x=x;
        this.y=y;
    }
    
    /* Copy constructor */
    public ComplexBig(ComplexBig z) {
        this.x=z.x;
        this.y=z.y;
    }


   public static ComplexBig times(ComplexBig z1,ComplexBig z2) {
       BigDecimal X0=z1.x.multiply(z2.x);
       BigDecimal X1=z1.y.multiply(z2.y);
       BigDecimal X=X0.subtract(X1);
       BigDecimal Y0=z1.x.multiply(z2.y);
       BigDecimal Y1=z1.y.multiply(z2.x);
       BigDecimal Y=Y0.add(Y1);
       ComplexBig Z=new ComplexBig(X,Y);
       return(Z);
   }

   public static ComplexBig plus(ComplexBig z1,ComplexBig z2) {
       ComplexBig Z=new ComplexBig();
       Z.x=z1.x.add(z2.x);
       Z.y=z1.y.add(z2.y);
       return(Z);
   }

   public static ComplexBig minus(ComplexBig z1,ComplexBig z2) {
       ComplexBig Z=new ComplexBig();
       Z.x=z1.x.subtract(z2.x);
       Z.y=z1.y.subtract(z2.y);
       return(Z);
   }

    public static ComplexBig conjugate(ComplexBig z) {
        return new ComplexBig(z.x,z.y.negate());
    }

    public static BigDecimal squareNorm(ComplexBig z) {
	ComplexBig w=conjugate(z);
	ComplexBig n=ComplexBig.times(z,w);
	return(n.x);
    }

    public static BigDecimal norm(ComplexBig z,int PRECISION) {
	BigDecimal s2=squareNorm(z);
  	return SqrtBig.sqrt(s2,PRECISION);
    }
    
    
    public static ComplexBig inverse(ComplexBig z) {
        BigDecimal n=ComplexBig.squareNorm(z);
	ComplexBig w=ComplexBig.conjugate(z);
	BigDecimal X=w.x.divide(n,100,BigDecimal.ROUND_FLOOR);
	BigDecimal Y=w.y.divide(n,100,BigDecimal.ROUND_FLOOR);
	return(new ComplexBig(X,Y));
    }


    public static ComplexBig divide(ComplexBig z,ComplexBig w) {
	return(times(z,inverse(w)));
    }

    public void print() {
	System.out.print("ComplexBig ");
	System.out.print(x.toString());
	System.out.print(" ");
	System.out.println(y.toString());
    }


    public String[] makeMyString() {
	String[] S=new String[2];
	S[0]=scaleFloor(x);
	S[1]=scaleFloor(y);
	return S;
    }
				 
public static String scaleFloor(BigDecimal x) {
    return x.multiply(new BigDecimal("1e32")).setScale(0, java.math.RoundingMode.FLOOR).toPlainString();
}
    
}
