import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.math.*;
import java.util.Arrays;

/**This stores the triangles around the link of
   a triangulation*/

public class Flower {

    
    public static int[] edgeLink(int link) {
int[][] l = {{1,2,4,6,5,3},
        {2,0,3,4,7,5},
        {0,1,5,6,7,4},
        {5,7,6,4,1,0},
        {0,2,7,1,3,6},
        {6,2,1,7,3,0},
        {0,4,3,7,2,5},
	{1,4,2,6,3,5}};
    return l[link];
    }
    
    
    /**combinatorial operation*/
    public static int[][] getLink(int link) {
	int[] cyc=edgeLink(link);
	int[][] f=new int[cyc.length][3];
	for(int i=0;i<cyc.length;++i) {
	    int j=(i+1)%cyc.length;
	    f[i][0]=link;
	    f[i][1]=cyc[i];
	    f[i][2]=cyc[j];
	}
	return f;
    }


    public static Vector[] seed() {
	Vector[] V=new Vector[8];
double[][] d=
{{0.755,0.65,0.4505057158597784},
{-0.455,0.345,0.4602816243343043},
{-0.17,1.14,0.4465388347031215},
{0.455,-0.345,0.4602816243343043},
{-0.755,-0.65,0.4505057158597784},
{-0.09,0.665,-0.53},
{0.17,-1.14,0.4465388347031215},
{0.09,-0.665,-0.53}};
	for(int i=0;i<8;++i) V[i]=new Vector(d[i]);
    return V;
    }



    /**these are the three routines*/

    public static Complex[][] flower(Vector[] V,int link) {
	int[][] f=getLink(link);
	Complex[][] Z=new Complex[6][3];
	double wind=0;
	for(int i=0;i<6;++i) {
	    double[] d=SSA(f[i],V);
	    Z[i]=toTriangle(wind,d);
	    for(int ii=0;ii<3;++ii) {
		Z[i][ii].label=f[i][ii];
	    }
	    wind=wind+d[2];
	}
	wind=wind/(2*Math.PI)-1;
	return Z;
    }

    /**triangle creation*/
    
    public static Complex[] toTriangle(double h,double[] d) {
	Complex z0=new Complex(0,0);
	Complex z1=new Complex(d[0],0);
	double x=d[1]*Math.cos(d[2]);
	double y=d[1]*Math.sin(d[2]);
	Complex z2=new Complex(x,y);
	Complex[] Z={z0,z1,z2};
	double c=Math.cos(h);
	double s=Math.sin(h);
	Complex w=new Complex(c,s);
	for(int i=1;i<3;++i) Z[i]=Complex.times(w,Z[i]);
	return Z;
    }

    
    public static double[] SSA(int[] f,Vector[] V) {
	Vector A=Vector.minus(V[f[1]],V[f[0]]);
	Vector B=Vector.minus(V[f[2]],V[f[0]]);
	Vector UA=A.unit();
	Vector UB=B.unit();
	double a=Vector.dot(UA,UB);
	a=Math.acos(a);
	double[] d={A.norm(),B.norm(),a};
	return d;
    }



}
