import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.math.*;
import java.util.Arrays;

/**This stores the triangles around the link of
   a triangulation*/

public class FlowerBig {

    
    public static int[] edgeLink(int link) {
int[][] l = {{1,2,4,6,5,3},
        {2,0,3,4,7,5},
        {0,1,5,6,7,4},
        {5,7,6,4,1,0},
        {0,2,7,1,3,6},
        {6,2,1,7,3,0},
        {0,4,3,7,2,5},
	{1,4,2,6,3,5}};
    return l[link];
    }
    
    
    /**combinatorial operation*/
    public static int[][] getLink(int link) {
	int[] cyc=edgeLink(link);
	int[][] f=new int[cyc.length][3];
	for(int i=0;i<cyc.length;++i) {
	    int j=(i+1)%cyc.length;
	    f[i][0]=link;
	    f[i][1]=cyc[i];
	    f[i][2]=cyc[j];
	}
	return f;
    }
public static VectorBig[] seed() {
    int p = 150;
    return new VectorBig[] {
        new VectorBig("0.755", "0.650", "0.450505715859779355616538200856930055532448886618237640925103139985289690002191976305294416054139729796612391447363149946183200299471354572755977912562", p),
        new VectorBig("-0.455", "0.345", "0.460281624334305429343176158583280396315901051356169983639853013016662296044170122247973511673207420218893129529639394008499822410123043291219556821838", p),
        new VectorBig("-0.170", "1.140", "0.446538834703123176241842456724343419272338478043136343176666594416565345826663259911246838515637143541864964474541218471823490251259216869087544915401", p),
        new VectorBig("0.455", "-0.345", "0.460281624334305429343176158583280396315901051356169983639853013016662296044170122247973511673207420218893129529639394008499822410123043291219556821838", p),
        new VectorBig("-0.755", "-0.650", "0.450505715859779355616538200856930055532448886618237640925103139985289690002191976305294416054139729796612391447363149946183200299471354572755977912562", p),
        new VectorBig("-0.090", "0.665", "-0.530", p),
        new VectorBig("0.170", "-1.140", "0.446538834703123176241842456724343419272338478043136343176666594416565345826663259911246838515637143541864964474541218471823490251259216869087544915401", p),
        new VectorBig("0.090", "-0.665", "-0.530", p)
    };
}


    public static ComplexBig[][] flower(VectorBig[] V,int link,int PRECISION) {
	int[][] f=getLink(link);
	ComplexBig[][] Z=new ComplexBig[6][3];
	BigDecimal wind=new BigDecimal("0");
	for(int i=0;i<6;++i) {
	    BigDecimal[] d=SSA(f[i],V,PRECISION);
	    Z[i]=toTriangle(wind,d,PRECISION);
	    for(int ii=0;ii<3;++ii) {
		Z[i][ii].label=f[i][ii];
	    }
	    
	    wind=wind.add(d[2]);
	}
	return Z;
    }


    public static ComplexBig[] toTriangle(BigDecimal h,BigDecimal[] d,int PRECISION) {
	MathContext mc=new MathContext(PRECISION);
	BigDecimal ZERO=new BigDecimal("0");
	ComplexBig z0=new ComplexBig(ZERO,ZERO);//zero
	ComplexBig z1=new ComplexBig(d[0],ZERO);
	BigDecimal x=d[1].multiply(CosBig.cos(d[2],PRECISION),mc);
	BigDecimal y=d[1].multiply(CosBig.sin(d[2],PRECISION),mc);
	ComplexBig z2=new ComplexBig(x,y);
	ComplexBig[] Z={z0,z1,z2};
	BigDecimal c=CosBig.cos(h,PRECISION);
	BigDecimal s=CosBig.sin(h,PRECISION);
	ComplexBig w=new ComplexBig(c,s);
	for(int i=1;i<3;++i) Z[i]=ComplexBig.times(w,Z[i]);
	return Z;
    }

    
    
    public static BigDecimal[] SSA(int[] f,VectorBig[] V,int PRECISION) {
	VectorBig A=VectorBig.minus(V[f[1]],V[f[0]]);
	VectorBig B=VectorBig.minus(V[f[2]],V[f[0]]);
	VectorBig AA=A.unit(PRECISION);
	VectorBig BB=B.unit(PRECISION);
	BigDecimal ab=VectorBig.dot(AA,BB);
	ab=AcosBig.acos(ab,PRECISION);
	BigDecimal[] d={A.norm(PRECISION),B.norm(PRECISION),ab};
	return d;
    }

}
