import java.awt.event.*;
import java.awt.*;

/*This class does the basic arithmetic of complex numbers */

public class Complex {
    double x,y;
    int label;
    
    public Complex() {
        this.x=0.0;
        this.y=0.0;
    } 
    
    public Complex(double x,double y) {
        this.x=x;
        this.y=y;
    }
    
    public Complex(Complex z) {
        this.x=z.x;
        this.y=z.y;
	this.label=z.label;
    }

    public static Complex plus(Complex z1,Complex z2) {
        return new Complex(z1.x+z2.x, z1.y+z2.y);
    }

    public static Complex minus(Complex z1,Complex z2) {
        return new Complex(z1.x-z2.x, z1.y-z2.y);
    }
    

    public static Complex times(Complex z1,Complex z2) {
        return new Complex(z1.x*z2.x-z1.y*z2.y,
        z1.x*z2.y+z1.y*z2.x);
    }

    public static Complex divide(Complex z1,Complex z2) {
        return times(z1,z2.inverse());
    }
    
    public static Complex conjugate(Complex z) {
        Complex w=new Complex(z.x,-z.y);
	w.label=z.label;
	return w;
    }
    
    public double norm() {
        return Math.sqrt(x*x+y*y);
    }

    public static double dist(Complex a,Complex b) {
	Complex c=minus(a,b);
	return c.norm();
    }

    
    public double norm2() {
        return x*x+y*y;
    }

    public Complex unit() {
        double d=norm();
        return new Complex(x/d,y/d);
    }

    public Complex inverse() {
        double d=x*x+y*y;
        return new Complex(x/d,-y/d);
    }
    
    public Complex conjugate() {
        return new Complex(x,-y);
    }
    
    public double arg(){
        return Math.atan2(y,x);
    }

    public Complex scale(double r) {
	return new Complex(r*x,r*y);
    }

    public static boolean isPositivelyOriented(Complex[] z) {
	return isPositivelyOriented(z[0],z[1],z[2]);
    }
    
    public static boolean  isPositivelyOriented(Complex z1,Complex z2,Complex z3) {
        Complex[] z=new Complex[5];
        for(int i=1;i<=4;++i) z[i]=new Complex();
        z[1]=Complex.minus(z2,z1);
        z[2]=Complex.minus(z3,z1);
        z[3]=Complex.conjugate(z[2]);
        z[4]=Complex.times(z[1],z[3]);
	if(z[4].y<0) return(true);
	return(false);
    }


    public void print() {
	System.out.println("Complex: "+this.x+" "+this.y);
	System.out.println("label "+label);
    }
}

