import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.math.*;
import java.util.Arrays;


public class ControlCanvas extends ScaleCanvas implements MouseListener, MouseMotionListener {
    Manager M;
    SelectColor CS;
    ControlPanel ACTION;
    ControlPanelColor DISPLAY;
    ListenSquare PRINT,TEST;
    boolean started;

     public ControlCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 CS=new SelectColor(M,0,149,399,50);
	 TEST=new ListenSquare(280,90,50,30);
	 setPanels();
	 started=false;
     }

   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);
      drawControls(g);
   }

    
    public void setPanels() {

       Color[] C0={new Color(100,150,255),
                   Color.white,
                   Color.white,
                   Color.black,
                   Color.white};
       
       String[] DisplayString={"bg",
			       "triangles",
			       "exterior t's",
			       "vertices",
			       "edges",
			       "highlight0",
			       "highlight1",
			       "display"};
       
       Color[] DisplayColor={Color.white,
			     Color.white,
			     new Color(100,200,255),
			     Color.black,
			     Color.black,
			     Color.blue,
			     new Color(0,150,0)};
       int[] DisplayState={1,1,1,1,1,0,0};
       DISPLAY=new ControlPanelColor(C0,DisplayString,DisplayState,7,DisplayColor);

       
       String[] ActionString={"vertices",
			      "jacobian",
			      "geometric estimates",
			      "separation vectors 0",
			      "separation vectors 1",
			      "separation vectors 2",
			       "action"};

       int[] ActionState={1,0,0,0,0,0};
       ACTION=new ControlPanel(C0,ActionString,ActionState,6);
    }
    

    public void drawBG(Graphics2D g) {
	g.setColor(new Color(155,0,200));
        g.fillRect(0,0,getWidth(),getHeight()); 
    }
    
    public void drawControls(Graphics2D g) { 
      CS.render(g);
      g.setColor(Color.white);
      g.setFont(new Font("Helvetica",Font.PLAIN,16));
      TEST.render(g,Color.blue,"action");
      DISPLAY.render(g,0,0,100);
      ACTION.render(g,105,0,150);
    }
    
    public void mouseClicked(MouseEvent e) {
        CS.process(e); 
        MouseData J=MouseData.process(e);
	DISPLAY.process(J.X,CS.C);
	ACTION.switchMode(J.X);
	if(TEST.inside(J.X)==1) Tester.main(this.M);
        M.repaint();
    }

    public void doTest() {
	Torus T=seed();
	Vector c=new Vector();
	for(int i=0;i<8;++i) c=Vector.plus(c,T.U[i]);
	c=c.scale(1.0/8);
	c.x[2]=c.x[2]-.35;
	for(int i=0;i<8;++i) {
	    double d=Vector.dist(c,T.U[i]);
	    System.out.println(d);
	}


    }
    



    public static Vector rot(Vector V) {
	double s=1.0/Math.sqrt(2);
	Vector W=new Vector(V.x[0],s*V.x[1]-s*V.x[2],s*V.x[1]+s*V.x[2]);
	return W;
    }
    

    public void mousePressed(MouseEvent e) {
       MouseData J=MouseData.process(e);
       repaint();
    }

	
     public void mouseReleased(MouseEvent e) {}
     public void mouseEntered(MouseEvent e) {
     requestFocus();
     }


	 
     public void mouseExited(MouseEvent e) {}   
     public void mouseMoved(MouseEvent e) {
     }

	 
     public void mouseDragged(MouseEvent e) {
        CS.process(e); 
        MouseData J=MouseData.process(e);
	M.repaint();
     }
    

    /**This is the (near) flat torus*/
  
    public static Torus seed() {
	Torus T=new Torus();
double[][] d=
{{0.755,0.65,0.4505057158597784},
{-0.455,0.345,0.4602816243343043},
{-0.17,1.14,0.4465388347031215},
{0.455,-0.345,0.4602816243343043},
{-0.755,-0.65,0.4505057158597784},
{-0.09,0.665,-0.53},
{0.17,-1.14,0.4465388347031215},
{0.09,-0.665,-0.53}};
	for(int i=0;i<8;++i) T.U[i]=new Vector(d[i]);
    return T;
    }
    
    
}

