import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.math.*;
import java.util.Arrays;

/**This stores the triangles around the link of
   a triangulation*/

public class Flower {
    Complex[][] Z=new Complex[7][3];
    boolean[] ext=new boolean[7];
    int size; //number of triangles
    Complex center;
    Complex phase; //this is the rotation


    public Flower() {}

    public Flower(Flower F) {
	this.size=F.size;
	this.center=new Complex(F.center);
	this.phase=new Complex(F.phase);
	for(int i=0;i<size;++i) ext[i]=F.ext[i];
	for(int i=0;i<F.size;++i) {
	    for(int j=0;j<3;++j) {
		Z[i][j]=new Complex(F.Z[i][j]);
	    }
	}
    }

    public static int[] edgeLink(int link) {
int[][] l = {{1,2,4,6,5,3},
        {2,0,3,4,7,5},
        {0,1,5,6,7,4},
        {5,7,6,4,1,0},
        {0,2,7,1,3,6},
        {6,2,1,7,3,0},
        {0,4,3,7,2,5},
	{1,4,2,6,3,5}};
    return l[link];
    }
    
    int[][] externalFaces() {
	int[][] f={{0,1,2},{0,1,3},{1,2,5},{1,3,4},{3,4,6},{3,6,7}};
	return f;
    }

    public Flower(Torus T,int link) {
	int[][] face=externalFaces();
	int[][] f=getLink(link);
	size=f.length;
	phase=new Complex(1,0);
	center=new Complex(0,0);
	
	double wind=0;
	for(int i=0;i<size;++i) {
	    double[] d=SSA(f[i],T.U);
	    Z[i]=toTriangle(wind,d);
	    for(int ii=0;ii<3;++ii) {
		Z[i][ii].label=f[i][ii];
	    }
	    ext[i]=isExterior(f[i],face);
	    wind=wind+d[2];
	}
	wind=wind/(2*Math.PI)-1;
    }

    public Complex point(int i,int j) {
	Complex z=new Complex(Z[i][j]);
	z=Complex.times(z,phase);
	z=Complex.plus(z,center);
	return z;
    }
    
    /**combinatorial operation*/
    public static int[][] getLink(int link) {
	int[] cyc=edgeLink(link);
	int[][] f=new int[cyc.length][3];
	for(int i=0;i<cyc.length;++i) {
	    int j=(i+1)%cyc.length;
	    f[i][0]=link;
	    f[i][1]=cyc[i];
	    f[i][2]=cyc[j];
	}
	return f;
    }


    /**exterior test*/
    public boolean isExterior(int[] f,int[][] face) {
	for(int i=0;i<face.length;++i) {
	    if(ListHelp.match(f,face[i])==true) return true;
	}
	return false;
    }
    

    /**triangle creation*/
    
    public static Complex[] toTriangle(double h,double[] d) {
	Complex z0=new Complex(0,0);
	Complex z1=new Complex(d[0],0);
	double x=d[1]*Math.cos(d[2]);
	double y=d[1]*Math.sin(d[2]);
	Complex z2=new Complex(x,y);
	Complex[] Z={z0,z1,z2};
	double c=Math.cos(h);
	double s=Math.sin(h);
	Complex w=new Complex(c,s);
	for(int i=1;i<3;++i) Z[i]=Complex.times(w,Z[i]);
	return Z;
    }
    
    public static double[] SSA(int[] f,Vector[] V) {
	Vector A=Vector.minus(V[f[1]],V[f[0]]);
	Vector B=Vector.minus(V[f[2]],V[f[0]]);
	Vector UA=A.unit();
	Vector UB=B.unit();
	double a=Vector.dot(UA,UB);
	a=Math.acos(a);
	double[] d={A.norm(),B.norm(),a};
	return d;
    }


    /**rendering*/

    public void render(Graphics2D g,ShapeCanvas S,int thick) {
	for(int i=0;i<size;++i) render(g,S,i,thick);
    }
    
    
    public void render(Graphics2D g,ShapeCanvas S,int i,int thick) {
	Path2D.Double p=new Path2D.Double();
	Complex[] W=new Complex[3];
	for(int j=0;j<3;++j) {
	    W[j]=new Complex(Z[i][j]);
	    W[j]=Complex.times(W[j],phase);
	    W[j]=Complex.plus(W[j],center);
	}
	p.moveTo(W[0].x,W[0].y);
	p.lineTo(W[1].x,W[1].y);
	p.lineTo(W[2].x,W[2].y);
	p.closePath();
	p=S.transform(p);
	g.setColor(S.M.C.DISPLAY.M[1].C);
	if(ext[i]==true) g.setColor(S.M.C.DISPLAY.M[2].C);
	g.fill(p);
	g.setColor(S.M.C.DISPLAY.M[4].C);
	g.setStroke(new BasicStroke(thick));
	g.draw(p);
	g.setStroke(new BasicStroke(1));
    }

    


    


    /**this changes flower F2*/
    public Flower translate(Complex z) {
	Flower F=new Flower(this);
	F.center=Complex.plus(F.center,z);
	return F;
    }
	
    
    public void align(Flower F2) {
	Complex[] W=alignData(this,F2);
	if(W==null) return;
	Complex z1=Complex.minus(W[1],W[0]);
	Complex z2=Complex.minus(W[3],W[2]);
	F2.phase=Complex.divide(z1,z2);
	Complex zz=Complex.times(F2.phase,W[2]);
	F2.center=Complex.plus(F2.center,Complex.minus(W[0],zz));
    }

    public boolean canAlign(Flower F2) {
	Complex[] W=alignData(this,F2);
	if(W==null) return false;
	return true;
    }

    public static Complex[] alignData(Flower F1,Flower F2) {
	int[] L=match(F1,F2);
	if(L==null) return null;
	int[] a=F1.labels(L[0]);
	Complex[] W=new Complex[4];
	W[0]=new Complex(F1.Z[L[0]][0]);
	W[1]=new Complex(F1.Z[L[0]][1]);
	for(int i=0;i<3;++i) {
	    if(F2.Z[L[1]][i].label==W[0].label) W[2]=new Complex(F2.Z[L[1]][i]);
	    if(F2.Z[L[1]][i].label==W[1].label) W[3]=new Complex(F2.Z[L[1]][i]);
	}
	return W;
    }
	

    public static int[] match(Flower F1,Flower F2) {
	for(int i=0;i<F1.size;++i) {
	    for(int j=0;j<F2.size;++j) {
		int[] a=F1.labels(i);
		int[] b=F2.labels(j);
		if(ListHelp.match(a,b)==true) {
		    int[] A={i,j};
		    return A;
		}
	    }
	}
	return null;
    }

     public int[] labels(int q) {
	int[] L=new int[3];
	for(int i=0;i<3;++i) L[i]=Z[q][i].label;
	return L;
     }



	
    public static Complex[] getLattice(Torus T) {
	Flower[] F=new Flower[8];
	for(int i=0;i<8;++i) F[i]=new Flower(T,i);

	for(int i=1;i<8;++i) {
           if(F[0].canAlign(F[i])==true) {
             F[0].align(F[i]);
	   }
	}

	Complex z1=F[0].point(4,1);
	Complex z2=F[1].point(4,2);
	Complex z12=Complex.minus(z2,z1);
	Complex z3=F[4].point(0,0);
	Complex z4=F[1].point(2,2);
	Complex z34=Complex.minus(z3,z4);

	Complex[] W={z12,z34};
	return W;
    }

    public static Complex[] getFundamentalPoints(Torus T) {
	Complex[] ZZ=getLattice(T);
	Complex z12=ZZ[0];
	Complex z34=ZZ[1];
	
	Flower[] F=new Flower[8];
	for(int i=0;i<8;++i) F[i]=new Flower(T,i);

	for(int i=1;i<8;++i) {
           if(F[0].canAlign(F[i])==true) {
             F[0].align(F[i]);
	   }
	}
	
	Complex w0=F[0].point(0,0);
	Complex w1=F[0].point(0,1);
	Complex w2=F[0].point(1,1);
	Complex w3=F[0].point(4,2);
	Complex w4=F[0].point(2,1);
	Complex w5=F[0].point(3,2);
	Complex w6=F[0].point(2,2);
	Complex w7=F[1].point(4,1);

	w0=Complex.plus(w0,Complex.plus(z12,z34));
	w1=Complex.plus(w1,z34);
	w2=Complex.plus(w2,z34);
	w3=Complex.plus(w3,Complex.plus(z12,z34));
	w5=Complex.plus(w5,Complex.plus(z12,z34));
	w6=Complex.plus(w6,z12);
	w7=Complex.plus(w7,z34);

	Complex[] ww={w0,w1,w2,w3,w4,w5,w6,w7};
	for(int i=0;i<8;++i) ww[i].label=i;
	return ww;
    }


    
    public void print(int q) {
	for(int i=0;i<3;++i) {
	    Z[q][i].print();
	}
    }

}
