import java.awt.event.*;
import java.awt.*;


public class NumericalSeparation2 {


    
    public static int firstWinner(int k,double tol) {
	int count=0;
	boolean test=separatorWorks(k,0,tol);
	if(test==true) return 0;
	test=separatorWorks(k,1,tol);
        if(test==true) return 1;
	return -1;
    }
    


    public static Vector[] candidateDirections(int k) {
	Vector[] V=normalPair(k);
	Vector[] W=new Vector[2];
	W[0]=Vector.plus(V[0],V[1]);
	W[1]=Vector.minus(V[0],V[1]);
	W[0]=W[0].unit();
	W[1]=W[1].unit();
	return W;
    }




    public static Vector[] normalPair(int k) {
	Vector v0=normal(k,0);
	Vector v1=normal(k,1);
	Vector[] v={v0,v1};
	return v;
    }




    public static Vector normal(int k,int q) {
	Vector[] A=triangle(k,q);
	Vector v1=Vector.minus(A[1],A[0]);
	Vector v2=Vector.minus(A[2],A[0]);
	Vector w=Vector.cross(v1,v2);
	w=w.unit();
	return w;
    }
	


    
    

    public static boolean separatorWorks(int k,int n,double tol) {
	double[][] d=targeted(k,n);
	if(Math.max(d[0][0],d[0][1])<Math.min(d[1][0],d[1][1])-tol) return true;
	if(Math.min(d[0][0],d[0][1])>Math.max(d[1][0],d[1][1])+tol) return true;
	return false;
    }



    public static double[][] targeted(int k,int n) {
	Vector[] A=candidateDirections(k);
  	Vector B=A[n];
	return LF(k,B);
    }


    public static double[][] LF(int k,Vector L) {
	double[] d0={100000,-100000};
	double[] d1={100000,-100000};
	Vector[] T0=triangle(k,0);
	Vector[] T1=triangle(k,1);
	
	for(int i=2;i<3;++i) {
	    double test=Vector.dot(L,T0[i]);
	    if(d0[0]>test) d0[0]=test;
	    if(d0[1]<test) d0[1]=test;
	}
	
	for(int i=2;i<3;++i) {
	    double test=Vector.dot(L,T1[i]);
	    if(d1[0]>test) d1[0]=test;
	    if(d1[1]<test) d1[1]=test;
	}
	double[][] d={d0,d1};
	return d;
    }


    public static double dec(double x) {
	double y=x-Math.floor(x);
	return 1-2*y;
    }


    public static Vector pseudoRandom(int n) {
	double d1=dec(n*Math.sqrt(2));
	double d2=dec(n*Math.sqrt(3));
	double d3=dec(n*Math.sqrt(5));
	Vector V=new Vector(d1,d2,d3);
	V=V.unit();
	return V;
    }
    

    public static Vector[] triangle(int k,int q) {
	int[][][] D2=TriangulationCombinatorics.D2();
	Torus T=TorusCanvas.seed();
	int[][] E0=D2[k];
	int[] f=E0[q];
	Vector[] A={T.U[f[0]],T.U[f[1]],T.U[f[2]]};
	return A;
    }

    
}



