import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.math.*;
import java.util.Arrays;


public class PictureCanvas extends ScaleCanvas implements MouseListener, MouseMotionListener {
    Manager M;
    Color COLOR;
    Complex[] CLOUD;
    long PATTERN;
    int VERTEX;
    
  

     public PictureCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 setScales(100,400,300);
	 COLOR=new Color(255,180,0);
	 CLOUD=TriangulationGeometry.getCloud();
	 PATTERN=0;
	 VERTEX=0;
     }


   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);
      drawTriangles(g);
      drawBoundaryTriangles(g);
      drawVertices(g);
   }

    public void drawBG(Graphics2D g) {
	g.setColor(new Color(0,0,0));
        g.fillRect(0,0,getWidth(),getHeight());
	Path2D.Double p=new Path2D.Double();
	for(int i=-2;i<3;++i) {
	    for(int j=-2;j<3;++j) {
		p.reset();
		p.moveTo(i,j);
		p.lineTo(i,j+1);
		p.lineTo(i+1,j+1);
		p.lineTo(i+1,j);
		p.closePath();
		p=transform(p);
		g.setColor(Color.blue);
		g.draw(p);
	    }
	}
    }
    
    public void drawTriangles(Graphics2D g) {
	if(M.C.DISPLAY.L[1].on==0) return;
	Complex[] cloud=Arrays.copyOf(CLOUD,CLOUD.length);
	Color COL1=M.C.DISPLAY.M[1].C;
	Color COL2=M.C.DISPLAY.M[4].C;
    	int[][] t=TriangulationCombinatorics.tiling();
	int link=1;
         for(int i=0;i<16;++i) {
            Complex[] w=triang(cloud,t[i]);
	    drawTriangExtended(g,w,COL1,COL2);
       	}

    }

    public void drawBoundaryTriangles(Graphics2D g) {
	if(M.C.DISPLAY.L[2].on==0) return;
	 int[][] FACE={{0,1,2},{0,1,3},{1,2,5},{1,3,4},{3,4,6},{3,6,7}};
	Complex[] cloud=Arrays.copyOf(CLOUD,CLOUD.length);
       	int[][] t=TriangulationCombinatorics.tiling();
	int link=1;
	Color COL1=M.C.DISPLAY.M[2].C;
	Color COL2=M.C.DISPLAY.M[4].C;
         for(int i=0;i<FACE.length;++i) {
            Complex[] w=triang(cloud,FACE[i]);
	    drawTriangExtended(g,w,COL1,COL2);
       	}

    }

    
    public void drawVertices(Graphics2D g) {
	if(M.C.DISPLAY.L[3].on==0) return;
	Font f=new Font("Helvetica",Font.PLAIN,20);
	Complex[] cloud=Arrays.copyOf(CLOUD,CLOUD.length);
	Color COL1=M.C.DISPLAY.M[3].C;
	Color COL2=Color.black;
	if(COL1.getRed()+COL1.getGreen()+COL1.getBlue()<200) COL2=Color.white;
    	for(int k=0;k<cloud.length;++k) {
	    fillPoint(g,cloud[k],.04,COL1,32);
	    Integer I=Integer.valueOf(cloud[k].label);
	    Complex z0=transformDirect(cloud[k]);
	    drawStringNicely(g,f,I.toString(),(int)(z0.x+1),(int)(z0.y),COL2);
	}

    }

    /**draws the labels*/

    public void drawStringNicely(Graphics2D g,Font f,String S,int x0,int y0,Color C) {
	FontMetrics fm=g.getFontMetrics(f);
	int t1=fm.stringWidth(S);
	int t2=fm.getHeight();
	int x=x0-7;
	int y=y0+7;
	g.setFont(f);
	g.setColor(C);
	g.drawString(S,x,y);
    }

    /**gets triangles in the universal cover*/

    public static Complex[] triang(Complex[] cloud,int[] t) {
	Complex[] w=new Complex[3];
	w[0]=TriangulationGeometry.inFundamentalSquare(cloud,t[0]);
  	w[1]=TriangulationGeometry.closest(w[0],cloud,t[1]);
	w[2]=TriangulationGeometry.closest(w[0],cloud,t[2]);
	return w;
    }

    /**gets edges in the universal cover*/
    
    public static Complex[] edge(Complex[] cloud,int[] t) {
	Complex[] w=new Complex[2];
	w[0]=TriangulationGeometry.inFundamentalSquare(cloud,t[0]);
  	w[1]=TriangulationGeometry.closest(w[0],cloud,t[1]);
	return w;
    }

    /**draws triangles in the universal cover*/
    
    public void drawTriangExtended(Graphics2D g,Complex[] z,Color COL1,Color COL2) {
	for(int i=-2;i<=2;++i) {
	    for(int j=-2;j<=2;++j) {
	       Path2D.Double p=new Path2D.Double();
	       p.moveTo(z[0].x+i,z[0].y+j);
	       p.lineTo(z[1].x+i,z[1].y+j);
	       p.lineTo(z[2].x+i,z[2].y+j);
	       p.closePath();
	       p=transform(p);
	       g.setColor(COL1);
	       g.fill(p);
	       g.setColor(COL2);
	       g.draw(p);
	    }
	}
    }
	
    /*draws edges in the universal cover*/
    
    public void drawEdgeExtended(Graphics2D g,Complex[] z,Color COL,int thick) {

	
	for(int i=-2;i<=2;++i) {
	    for(int j=-2;j<=2;++j) {
	       Path2D.Double p=new Path2D.Double();
	       p.moveTo(z[0].x+i,z[0].y+j);
	       p.lineTo(z[1].x+i,z[1].y+j);
	       p.closePath();
	       p=transform(p);
	       g.setStroke(new BasicStroke(thick));
	       g.setColor(COL);
	       g.draw(p);
	    }
	}
        g.setStroke(new BasicStroke(1));
    }
    

    public void mousePressed(MouseEvent e) { }
    
    public void mouseClicked(MouseEvent e) { 
	MouseData J=MouseData.process(e);
        if(J.mode==1)  scaleUp(J.X,0);
        if(J.mode==3)  scaleUp(J.X,1);
	if(J.mode==2) {
	    SOURCE=unTransform(J.X);
	    // updateCloud();
	}
	repaint();
    }

    public void mouseDragged(MouseEvent e) { 
	MouseData J=MouseData.process(e);
	if(J.mode==2) {
	    SOURCE=unTransform(J.X);
	    //  updateCloud();
	}
	repaint();
    }
    
     public void mouseReleased(MouseEvent e) {	 
     }

     public void mouseEntered(MouseEvent e) {}
     public void mouseExited(MouseEvent e) {}   

     public void mouseMoved(MouseEvent e) {}



    public void updateCloud() {
       int index=TriangulationGeometry.closestIndex(SOURCE,CLOUD);
       int label=CLOUD[index].label;
       Complex diff=Complex.minus(SOURCE,CLOUD[index]);

       for(int i=0;i<CLOUD.length;++i) {
       if(CLOUD[i].label==label) {
         CLOUD[i]=Complex.plus(CLOUD[i],diff);
         CLOUD[i].label=label;
       }}
    }

    
}

