import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.math.*;
import java.util.Arrays;


public class ShapeCanvas extends ScaleCanvas implements MouseListener, MouseMotionListener {
    Manager M;
    Shape T;
    ListenSquare CONTROL;
    Lever COORD;
    ControlPanel DISPLAY;
    SelectInteger LINK;
    double trans;
    

     public ShapeCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);

	 setScales(250,250,70);
	 setPanels();
	 CONTROL=new ListenSquare(0,0,getWidth(),70);
     }

    public void setPanels() {

       Color[] C0={new Color(100,150,255),
                   Color.white,
                   Color.white,
                   Color.black,
                   Color.white};

       String[] DisplayString={"tiling","fund domain","points","display"};
       int[] DisplayState={1,1,0};
       DISPLAY=new ControlPanel(C0,DisplayString,DisplayState,3);
    }

   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);
      if(DISPLAY.L[0].on==1)  drawTiling(g);
      if(DISPLAY.L[1].on==1)  drawDomain(g);
      if(DISPLAY.L[2].on==1)  drawPoints(g);
      drawControls(g);
   }

    public void drawBG(Graphics2D g) {
	g.setColor(M.C.DISPLAY.M[0].C);
        g.fillRect(0,0,getWidth(),getHeight());
    }

    public void drawControls(Graphics2D g) {
  	CONTROL.w=getWidth();
	CONTROL.render(g,new Color(100,0,100));
	DISPLAY.render2(g,0,0,100);

    }

    public void drawTiling(Graphics2D g) {
	if(M.T.T==null) return;
	Flower[] F=new Flower[8];
	for(int i=0;i<8;++i) F[i]=new Flower(M.T.T,i);

	for(int i=1;i<8;++i) {
           if(F[0].canAlign(F[i])==true) {
             F[0].align(F[i]);
	   }
	}

	Complex[] ZZ=Flower.getLattice(M.T.T);
	Complex z12=ZZ[0];
	Complex z34=ZZ[1];
	
	

	for(int k=-4;k<5;++k) {
	    for(int j=-4;j<5;++j) {
	        for(int i=1;i<5;++i) {
		    Complex w12=z12.scale(k);
		    Complex w34=z34.scale(j);
		    Flower G=F[i].translate(w12);
		    G=G.translate(w34);
		    G.render(g,this,1);
		}
	    }
	}
	
    }
	
    public void drawDomain(Graphics2D g) {
	if(M.T.T==null) return;
	Flower[] F=new Flower[8];
	for(int i=0;i<8;++i) F[i]=new Flower(M.T.T,i);

	for(int i=1;i<8;++i) {
           if(F[0].canAlign(F[i])==true) {
             F[0].align(F[i]);
	   }
	}

	Complex[] ZZ=Flower.getLattice(M.T.T);
	Complex z12=ZZ[0];
	Complex z34=ZZ[1];
	
	Complex w0=F[0].point(0,0);
	Complex w4=F[0].point(2,1);
	Complex w04=Complex.plus(w0,w4);
	w04=w04.scale(.5);


	for(int i0=0;i0<2;++i0) {
	for(int i1=0;i1<2;++i1) {
	    
	Path2D.Double p=new Path2D.Double();
	Complex[] Z={new Complex(0,0),z12,Complex.plus(z12,z34),z34};
	for(int i=0;i<4;++i) {
	    Z[i]=Complex.plus(Z[i],w04);
	    Z[i]=Complex.plus(Z[i],Complex.plus(z12.scale(i0),z34.scale(i1)));
	}

	for(int i=0;i<4;++i) {
	    if(i==0) p.moveTo(Z[i].x,Z[i].y);
	    if(i!=0) p.lineTo(Z[i].x,Z[i].y);
	}
	p.closePath();
	g.setStroke(new BasicStroke(3));
	p=transform(p);
	g.setColor(Color.black);
	g.draw(p);
	g.setStroke(new BasicStroke(1));
	}}
    }



    public void drawPoints(Graphics2D g) {
	Complex[] ZZ=Flower.getLattice(M.T.T);
	Complex z12=ZZ[0];
	Complex z34=ZZ[1];
	Complex[] ww=Flower.getFundamentalPoints(M.T.T);

	Color[] COL={new Color(255,150,0),new Color(0,0,255),new Color(120,190,255),new Color(255,255,0),new Color(0,220,220),new Color(200,0,200),new Color(255,180,255),new Color(0,244,0)};


	for(int k=0;k<2;++k) {
	    for(int j=0;j<2;++j) {
	        for(int i=0;i<8;++i) {
		    Complex zz12=z12.scale(k);
		    Complex zz34=z34.scale(j);
		    Complex z=Complex.plus(ww[i],Complex.plus(zz12,zz34));
		    z.label=ww[i].label;
		    fillPoint(g,z,.15,Color.black,32);
		    fillPoint(g,z,.13,COL[z.label],32);
		}
	    }
	}

	        for(int i=0;i<8;++i) {
		    Complex z=ww[i];
		    ww[i].print();
		    fillPoint(g,z,.25,Color.black,32);
		    fillPoint(g,z,.23,COL[z.label],32);
		}
    }



    
	
    
    public void mousePressed(MouseEvent e) { }
    
    public void mouseClicked(MouseEvent e) { 
	MouseData J=MouseData.process(e);
	if(CONTROL.inside(J.X)==1) {
	    doControls(J.X);
	    M.repaint();
	    return;
	}
	
        if(J.mode==1)  scaleUp(J.X,0);
        if(J.mode==3)  scaleUp(J.X,1);
	SOURCE=unTransform(J.X);
	M.repaint();
    }

    public void mouseDragged(MouseEvent e) { 
	MouseData J=MouseData.process(e);
	if(J.mode==2) {
	    SOURCE=unTransform(J.X);
	}
	M.repaint();
    }
    
     public void mouseReleased(MouseEvent e) {	 
     }

     public void mouseEntered(MouseEvent e) {}
     public void mouseExited(MouseEvent e) {}   

     public void mouseMoved(MouseEvent e) {}   


    public void doControls(Point X) {
	DISPLAY.toggle(X);
    }
    
}

