import java.awt.event.*;
import java.awt.*;

/**This prints out data related to the paper torus*/

public class Tester {

    public static void main(Manager M) {
	int m=M.C.ACTION.mode;
	if(m==0) printTorus(M);
	if(m==1) printMatrix(M);
	if(m==2) printGeometry(M);
	if(m==3) sepVector0(M);
	if(m==4) sepVector1(M);
	if(m==5) sepVector2(M);
    }

    public static void printTorus(Manager M) {
	System.out.println("--------TORUS VERTICES----------");
	Torus T=M.C.seed();
	for(int i=0;i<8;++i) T.U[i].print();
	System.out.println("--------------------------------");
    }

    public static void printMatrix(Manager M) {
	System.out.println("--------JACOBIAN----------");
	Torus T=M.C.seed();
	Matrix m=Jacobian.main(T.U,.000000000001);
	m.print();
	System.out.println("");
	m=m.inverse();
	m.print();
    }


    public static void printGeometry(Manager M) {
	printAreaLowerBound(M);
	printEdgeBounds(M);
    }
    
    
    public static void printAreaLowerBound(Manager M) {
	Torus T=M.C.seed();
	double min=100;
	int[][] f=TriangulationCombinatorics.tiling();

	for(int k=0;k<3;++k) {
	for(int i=0;i<f.length;++i) {
	    int i0=k;
	    int i1=(k+1)%3;
	    int i2=(k+2)%3;
	    
	    Vector A=T.U[f[i][i0]];
	    Vector B=T.U[f[i][i1]];
	    Vector C=T.U[f[i][i2]];
	    Vector BB=Vector.minus(B,A);
	    Vector CC=Vector.minus(C,A);
	    BB.x[2]=0;
	    CC.x[2]=0;
	    Vector DD=Vector.cross(BB,CC);
	    double test=DD.norm();
	    if(min>test) min=test;
	}
	}

	System.out.println("area lower bound (for x2 in Ch. 7) "+min);
    }

    
    
    public static void printEdgeBounds(Manager M) {
	Torus T=M.C.seed();
	double min=100;
	double max=-100;
	int[][] f=TriangulationCombinatorics.tiling();

	for(int k=0;k<3;++k) {
	for(int i=0;i<f.length;++i) {
	    int i0=k;
	    int i1=(k+1)%3;
	    int i2=(k+2)%3;
	    
	    Vector A=T.U[f[i][i0]];
	    Vector B=T.U[f[i][i1]];
	    Vector C=T.U[f[i][i2]];
	    Vector BB=Vector.minus(B,A);
	    Vector CC=Vector.minus(C,A);
	    BB.x[2]=0;
	    CC.x[2]=0;
	    Vector DD=Vector.cross(BB,CC);
	    double test=Vector.dist(BB,CC);
	    if(test<min) min=test;
	    if(test>max) max=test;
	}
	}
	System.out.println("edge length bounds "+min+" "+max);
    }


    public static void sepVector0(Manager M) {
	System.out.println("==============Sepaaration vectors for disjoint triangles==========");
	for(int i=0;i<24;++i) {
	    int q=NumericalSeparation0.firstWinner(i,.005);
	    Vector V=NumericalSeparation0.pseudoRandom(q);
	    System.out.println("-------------------------");
	    System.out.print("pair index "+i);
	    System.out.println("     winning vector index "+q);
	    V.print();
	}
	System.out.println("==================================================================");
    }
    

    public static void sepVector1(Manager M) {
	System.out.println("==============Sepaaration vectors triangs with one common vertex==========");
	for(int i=0;i<72;++i) {
	    int q=NumericalSeparation1.firstWinner(i,.01);
	    Vector V=NumericalSeparation1.pseudoRandom(q);
	    System.out.println("-------------------------");
	    System.out.print("pair index "+i);
	    System.out.println("     winning vector index "+q);
	    V.print();
	}
	System.out.println("==================================================================");
    }
    
    
    public static void sepVector2(Manager M) {
	System.out.println("==============Sepaaration vectors triangs with two common vertices==========");
	for(int i=0;i<24;++i) {
	    int q=NumericalSeparation2.firstWinner(i,.005);
	    Vector V=NumericalSeparation2.pseudoRandom(q);
	    System.out.println("-------------------------");
	    System.out.print("pair index "+i);
	    System.out.println("     winning vector index "+q);
	    V.print();
	}
	System.out.println("==================================================================");
    }
    
    
    





    
}



    
