import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.math.*;
import java.util.Arrays;


public class TorusCanvas extends ScaleCanvas implements MouseListener, MouseMotionListener {
    Manager M;
    Torus T;
    ListenSquare CONTROL;
    Lever COORD,FOCUS;
    ControlPanel TORUS;
    HorizontalSlider SLICE;
    HorizontalSlider SLICE2;
    double slice,slice2;
    SelectInteger LINK;
    

     public TorusCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 setScales(250,250,70);
	 CONTROL=new ListenSquare(0,0,getWidth(),100);
	 COORD=new Lever(5,30,2,3);
	 FOCUS=new Lever(140,30,20,23);
	 SLICE=new HorizontalSlider(0,50,getWidth(),30,getWidth()/2,new Color(50,100,255),"slice coord");
	 SLICE2=new HorizontalSlider(0,80,getWidth(),20,getWidth()/2,new Color(0,0,255),"slice coord fine");
	 slice=.5;
	 slice2=.5;
	 setPanels();
	 T=seed();
	 LINK=new SelectInteger(510,5,50,25,0,0,8,1);
     }

    public void setPanels() {

       Color[] C0={new Color(100,150,255),
                   Color.white,
                   Color.white,
                   Color.black,
                   Color.white};

       String[] TorusString={"stars","slices","display"};
       int[] TorusState={1,0};
       TORUS=new ControlPanel(C0,TorusString,TorusState,2);
      }

   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);
      int mode=TORUS.mode;
      if(mode==0) drawLink(g);
      if(mode==1) {
	  drawSlice(g);
	  drawSliceFocus(g);
      }
      drawControls(g);
   }

    public void drawBG(Graphics2D g) {
	g.setColor(M.C.DISPLAY.M[0].C);
        g.fillRect(0,0,getWidth(),getHeight());
    }



    public void drawControls(Graphics2D g) {
	CONTROL.w=getWidth();
	CONTROL.render(g,new Color(0,0,200));
	COORD.render(g,new Color(50,100,255),"direction");
	FOCUS.render(g,new Color(50,100,255),"pair focus");
	TORUS.render(g,70,0,60);
	SLICE.w=getWidth();
	SLICE2.w=getWidth();
	SLICE.POS=(int)(slice*SLICE.w);
	SLICE2.POS=(int)(slice2*SLICE2.w);
	SLICE.render(g);
	SLICE2.render(g);
	g.setColor(Color.white);
	Integer I=Integer.valueOf(FOCUS.val);
	g.drawString(I.toString(),300,20);
	LINK.render(g,new Color(50,100,255),Color.white,Color.white);
    }

    

    /**This rotates so that the vector A is (0,0,1)*/

    public static Vector rotate(Vector A,Vector V) {
	Vector B0=new Vector(1,0,0);
	Vector B=cross(A,B0);
	B=B.unit();
	Vector C=cross(A,B);
	Vector[] m={C,B,A};
	Matrix M=new Matrix(m);
	M=M.inverse();
	M=M.transpose();
	return Matrix.act(M,V);
    }

    public static Vector cross(Vector v,Vector w) {
	Vector X=new Vector();
	X.x[0]=v.x[1]*w.x[2]-w.x[1]*v.x[2];
	X.x[1]=v.x[2]*w.x[0]-w.x[2]*v.x[0];
	X.x[2]=v.x[0]*w.x[1]-w.x[0]*v.x[1];
	return(X);
    }



    

    /**link drawing programs*/
    
    public void drawLink(Graphics2D g) {
	int count=0;
	int link=LINK.val;
	int[] cyc=TriangulationCombinatorics.edgeLink(link);
	Vector A=axis(link,cyc);
	if(A==null) return;

	for(int i=0;i<cyc.length;++i) {
	    int j=(i+1)%cyc.length;
  	    int[] f={link,cyc[i],cyc[j]};
	    if(f!=null) {
		drawLink(g,f,A);
		++count;
	    }
	}
    }

    public Vector axis(int link,int[] cycle) {
	if(T==null) return null;
	Vector W=new Vector(0,0,0);
	for(int i=0;i<cycle.length;++i) {
	    Vector R=Vector.minus(T.U[cycle[i]],T.U[link]);
	    R=R.unit();
	    W=Vector.plus(W,R);
	}
	W=W.unit();
	return W;
    }

    

    public void drawLink(Graphics2D g,int[] f,Vector A) {
  	if(T==null) return;
	Vector v0=T.U[f[0]];
	Vector v1=T.U[f[1]];
	Vector v2=T.U[f[2]];
	v1=Vector.minus(v1,v0);
	v2=Vector.minus(v2,v0);
   	v1=rotate(A,v1);
	v2=rotate(A,v2);
	
	Path2D.Double p=new Path2D.Double();
	for(int i=0;i<1000;++i) {
	    int j=i+1;
	    double t0=1.0*i/1000;
	    double t1=1.0*j/1000;
	    Vector w0=Vector.plus(v1.scale(1-t0),v2.scale(t0));
	    Vector w1=Vector.plus(v1.scale(1-t1),v2.scale(t1));
	    double[] z0=projectivize(w0);
	    double[] z1=projectivize(w1);
	    double x0=z0[0];
	    double y0=z0[1];
	    double x1=z1[0];
	    double y1=z1[1];
     	    int cc=coherent(w0,w1);
	    if(cc!=0) {
	       p.reset();
	       p.moveTo(x0,y0);
	       p.lineTo(x1,y1);
	       p=transform(p);
	       g.setColor(Color.red);
	       if(cc==-1) g.setColor(Color.blue);
	       g.draw(p);
	    }
	}
    }

    public static int coherent(Vector w0,Vector w1) {
	double x0=w0.x[2];
	double x1=w1.x[2];
	if(x0*x1<0) return 0;
	if(x0>0) return 1;
	return -1;
    }
    
    public static double[] projectivize(Vector w) {
	double x=w.x[0]/w.x[2];
	double y=w.x[1]/w.x[2];
	double[] z={x,y};
	return z;
    }
    /** end link drawing*/



    

    /**slice drawing programs*/
    

    public void drawSlice(Graphics2D g) {
	if(T==null) return;
	int m=COORD.val;
  	double[] e=T.extrema(m);
	e[0]=e[0]-.1;
	e[1]=e[1]+.1;
   	double d1=SLICE.getValue();
   	double d2=SLICE2.getValue()-.5;
	double d=d1+d2/20;
	d=(1-d)*e[0]+d*e[1];
    	int[][] f=TriangulationCombinatorics.tiling();
	Path2D.Double p=new Path2D.Double();
	for(int i=0;i<16;++i) {
	    Vector[] V={T.U[f[i][0]],T.U[f[i][1]],T.U[f[i][2]]};
	    Complex[] Z=getIntersectTriangle(m,V,d);
	    if(Z!=null) {
		p.moveTo(Z[0].x,Z[0].y);
		p.lineTo(Z[1].x,Z[1].y);
	    }
	}
	p=transform(p);
	g.setColor(M.C.DISPLAY.M[4].C);
	g.draw(p);
    }


    public void drawSliceFocus(Graphics2D g) {
	if(T==null) return;
	int m=COORD.val;
  	double[] e=T.extrema(m);
	e[0]=e[0]-.1;
	e[1]=e[1]+.1;
   	double d1=SLICE.getValue();
   	double d2=SLICE2.getValue()-.5;
	double d=d1+d2/20;
	d=(1-d)*e[0]+d*e[1];
    	int[][] f=TriangulationCombinatorics.tiling();

	int val=FOCUS.val;
	int[][][] face0=TriangulationCombinatorics.D0();
	int[][] face=face0[val];
	
	Path2D.Double p=new Path2D.Double();
	for(int i=0;i<16;++i) {
	    Vector[] V={T.U[f[i][0]],T.U[f[i][1]],T.U[f[i][2]]};
	    boolean test1=ListHelp.match(f[i],face[0]);
	    boolean test2=ListHelp.match(f[i],face[1]);
	    if((test1==true)||(test2==true)) {
		p.reset();
		 Complex[] Z=getIntersectTriangle(m,V,d);
	         if(Z!=null) {
		    p.moveTo(Z[0].x,Z[0].y);
		    p.lineTo(Z[1].x,Z[1].y);
		 }
	         p=transform(p);
	         if(test1==true) g.setColor(M.C.DISPLAY.M[5].C);
	         if(test2==true) g.setColor(M.C.DISPLAY.M[6].C);
		 g.draw(p);
	    }
	}
    }



    

    public static Complex[] getIntersectTriangle(int m,Vector[] V,double d) {
	Complex[] list=new Complex[2];
	int count=0;
	for(int i=0;i<3;++i) {
	    int j=(i+1)%3;
	    Vector[] W={V[i],V[j]};
	    Complex z=getIntersectSegment(m,W,d);
	    if(z!=null) {
		list[count]=z;
		++count;
	    }
	}
	if(count<2) return null;
	return list;
    }


    public static Complex getIntersectSegment(int m,Vector[] V,double d) {
	int a0=(m+1)%3;
	int a1=(m+2)%3;
	int a2=m;
	double x0=V[0].x[a0];
	double y0=V[0].x[a1];
	double z0=V[0].x[a2];
	double x1=V[1].x[a0];
	double y1=V[1].x[a1];
	double z1=V[1].x[a2];
	double test=(z0-d)*(z1-d);
	if(test>0) return null;
	double xx=x0*(1 - (-d + z0)/(z0 - z1)) + (x1*(-d + z0))/(z0 - z1);
	double yy=y0*(1 - (-d + z0)/(z0 - z1)) + (y1*(-d + z0))/(z0 - z1);
	return new Complex(xx,yy);
    }





    
    public void mousePressed(MouseEvent e) {
	MouseData J=MouseData.process(e);
	SLICE.activate(J.X);
	SLICE2.activate(J.X);
    }
    
    public void mouseClicked(MouseEvent e) { 
	MouseData J=MouseData.process(e);
	if(CONTROL.inside(J.X)==1) {
	    doControls(J.X);
	    repaint();
	    return;
	}
        if(J.mode==1)  scaleUp(J.X,0);
        if(J.mode==3)  scaleUp(J.X,1);
	SOURCE=unTransform(J.X);
	M.repaint();
    }

    public void mouseDragged(MouseEvent e) { 
	MouseData J=MouseData.process(e);
	if(J.mode==2) {
	    SLICE.configure(J.X);
	    SLICE2.configure(J.X);
	    slice=SLICE.getValue();
	    slice2=SLICE2.getValue();
	    SOURCE=unTransform(J.X);
	}
	M.repaint();
    }
    
     public void mouseReleased(MouseEvent e) {	 
     }

     public void mouseEntered(MouseEvent e) {}
     public void mouseExited(MouseEvent e) {}   

     public void mouseMoved(MouseEvent e) {}   



    public void doControls(Point X) {
	COORD.process(X);
	FOCUS.process(X);
	TORUS.switchMode(X);
	SLICE.configure(X);
	SLICE2.configure(X);
	slice=SLICE.getValue();
	slice2=SLICE2.getValue();
	LINK.modifyCyclic(X);
	M.repaint();
    }

    /**This is IT*/
  
    public static Torus seed() {
	Torus T=new Torus();
double[][] d=
{{0.755,0.65,0.4505057158597784},
{-0.455,0.345,0.4602816243343043},
{-0.17,1.14,0.4465388347031215},
{0.455,-0.345,0.4602816243343043},
{-0.755,-0.65,0.4505057158597784},
{-0.09,0.665,-0.53},
{0.17,-1.14,0.4465388347031215},
{0.09,-0.665,-0.53}};
	for(int i=0;i<8;++i) T.U[i]=new Vector(d[i]);
    return T;
    }
    
    
}

