
public class TriangleChecker {

    /**This is the main routine*/
    
    public static boolean embedded(Torus T,double tol) {
	int count=0;
	for(int i=0;i<16;++i) {
	for(int j=i+1;j<16;++j) {
  	    boolean test=testDisjoint(T.U,i,j,tol);
	   if(test==false) return false;
	}}
	return true;
    }

    public static boolean testDisjoint(Vector[] V,int a,int b,double tol) {
	int m=faceMatch(a,b);
	int[][] u=faceList(a,b);
	Vector[] S=new Vector[3];
	Vector[] T=new Vector[3];
	for(int i=0;i<3;++i) {
	    S[i]=V[u[0][i]];
	    T[i]=V[u[1][i]];
	}
	boolean test=true;
	if(m==0) test=dis0(S,T,tol);
       	if(m==1) test=dis1(S,T,tol);
	return test;
    }

    public static double foldQuality(Torus T) {
	double min=100;
	int count=0;
	for(int i=0;i<16;++i) {
	for(int j=i+1;j<16;++j) {
  	   double test=foldQuality(T.U,i,j);
	   if(test<min) min=test;
	}}
	return min;
    }
    
    public static double foldQuality(Vector[] V,int a,int b) {
	double theta=dihedralAngle(V,a,b);
	double b1=Math.abs(theta);
	double b2=Math.abs(1-theta);
	double b3=Math.abs(.5-theta);
	double[] c={b1,b2,b3};
	double min=100;
	for(int i=0;i<3;++i) {
	    if(min>c[i]) min=c[i];
	}
	return min;
    }

    public static double dihedralAngle(Vector[] V,int a,int b) {
	double max=100;
	int m=faceMatch(a,b);
	int[][] u=faceList(a,b);
	Vector[] S=new Vector[3];
	Vector[] T=new Vector[3];
	for(int i=0;i<3;++i) {
	    S[i]=V[u[0][i]];
	    T[i]=V[u[1][i]];
	}
	Vector s=Vector.cross(Vector.minus(S[2],S[0]),Vector.minus(S[1],S[0]));
	Vector t=Vector.cross(Vector.minus(T[2],T[0]),Vector.minus(T[1],T[0]));
	s=s.unit();
	t=t.unit();
	double d=Vector.dot(s,t);
	return Math.acos(d)/(2*Math.PI);
    }

    /**This assumes that there are no vertices in common. returns true if the
       triangles are disjoint*/

    public static boolean dis0(Vector[] S,Vector[] T,double tol) {
	Vector[] S12={S[1],S[2]};
	Vector[] S02={S[0],S[2]};
	Vector[] S01={S[0],S[1]};
	Vector[] T12={T[1],T[2]};
	Vector[] T02={T[0],T[2]};
	Vector[] T01={T[0],T[1]};
	boolean test=false;
	test=segmentHitsTriangle(S12,T,tol);
	if(test==true) return false;
	test=segmentHitsTriangle(S02,T,tol);
	if(test==true) return false;
	test=segmentHitsTriangle(S01,T,tol);
	if(test==true) return false;
	test=segmentHitsTriangle(T12,S,tol);
	if(test==true) return false;
	test=segmentHitsTriangle(T02,S,tol);
	if(test==true) return false;
	test=segmentHitsTriangle(T01,S,tol);
	if(test==true) return false;
	return true;
    }


    /**This assumes that the first vertex is common. returns true if the triangles are disjoint*/

    public static boolean dis1(Vector[] S,Vector[] T,double tol) {
	Vector[] S12={S[1],S[2]};
	Vector[] T12={T[1],T[2]};
	boolean test=false;
	test=segmentHitsTriangle(S12,T,tol);
	if(test==true) return false;
	test=segmentHitsTriangle(T12,S,tol);
	if(test==true) return false;
	return true;
    }

    public static boolean segmentHitsTriangle(Vector[] S,Vector[] T,double tol) {
	Vector[] X=new Vector[3];
	for(int i=0;i<3;++i) X[i]=Vector.minus(T[i],S[0]);
	Matrix m=new Matrix(X);
	m=m.transpose();
	m=m.inverse();
	Vector SS=Vector.minus(S[1],S[0]);
	Vector W=Matrix.act(m,SS);
	if(W.x[0]+W.x[1]+W.x[2]<1-tol) return false;
	for(int i=0;i<3;++i) {
	    if(W.x[i]<-tol) return false;
	}
	return true;
    }

    public static int[] face(int k) {
   	int[][] f=TriangulationCombinatorics.tiling();
	return f[k];
    }
    
    /**counts the number of vertices common to the two faces*/
    
    public static int faceMatch(int a,int b) {
	int[] A=face(a);
	int[] B=face(b);
	int count=0;
	for(int i=0;i<3;++i) {
	    for(int j=0;j<3;++j) {
		if(A[i]==B[j]) ++count;
	    }
	}
	return count;
    }

    /**returns the list of the vertices in the faces, with the common ones first*/
    
       public static int[][] faceList(int a,int b) {
 	int[] A=face(a);
	int[] B=face(b);
	return ListHelp.reorderCommonFirst(A,B);
    }

}
