import java.util.Arrays;

public class TriangulationGeometry {



    /**this gets the cloud point nearest the origin with the given
       label*/

    public static Complex inFundamentalSquare(Complex[] cloud,int label) {
	for(int i=0;i<cloud.length;++i) {
	    if(cloud[i].label==label) {
		double x=cloud[i].x;
		double y=cloud[i].y;
		x=x-Math.floor(x);
		y=y-Math.floor(y);
		return new Complex(x,y);
	    }
	}
	return null;
    }

    
    
    /**this finds the closest point in the orbit of w to z*/
    

    public static Complex closestInTorus(Complex z,Complex w) {
	double min=100;
	Complex h=new Complex();
	for(int i=-3;i<3;++i) {
	    for(int j=-3;j<3;++j) {
		Complex ww=Complex.plus(w,new Complex(i,j));
		double test=Complex.dist(z,ww);
		if(test<min) {
		    h=new Complex(ww);
		    min=test;
		}
	    }
	}
	return h;
    }


    public static Complex closest(Complex z,Complex[] cloud,int label) {
	double min=100;
	Complex h=new Complex();
	for(int i=0;i<cloud.length;++i) {
	    if(cloud[i].label==label) {
		double test=Complex.dist(z,cloud[i]);
		if(test<min) {
		    h=new Complex(cloud[i]);
		    min=test;
		}
	    }
	}
	return h;
    }



    public static int closestIndex(Complex z,Complex[] cloud) {
	double min=100;
	int index=-1;
	for(int i=0;i<cloud.length;++i) {
	    double test=Complex.dist(z,cloud[i]);
	    if(test<min) {
		index=i;
	        min=test;
	    }
	}
	return index;
    }


    

    /**This gets the coords for the triangulation*/
    
    public static Complex[] getCloud() {
	Complex[] z=coords();
	return makePeriodic(z);
    }



    public static Complex[] makePeriodic(Complex[] z) {
	Complex[] list=new Complex[2000];
	int count=0;

	for(int i=-2;i<=2;++i) {
	    for(int j=-2;j<=2;++j) {
		for(int k=0;k<8;++k) {
		    list[count]=Complex.plus(z[k],new Complex(i,j));
		    list[count].label=k;
		    ++count;
		}
	    }
	}
	return Arrays.copyOf(list,count);
    }

    public static Complex[] coords() {
Complex[] z={new Complex(0.451,0.58),new Complex(0.71,0.324),new Complex(0.799,0.683),new Complex(0.32,0.219),new Complex(0.529,0.929),new Complex(0.062,0.457),new Complex(0.169,0.8),new Complex(0.931,0.06)};
	return z;
    }


}
