import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class ControlCanvas extends ScaleCanvas implements MouseListener,MouseMotionListener {
    ListenSquare CONTROL,SLIDER,GO,STOP;
    SelectInteger[][] COEFF=new SelectInteger[10][2];
    SelectInteger DEGREE,RANGE,SPEED;
    Color COLOR;
    double INPUT;
    Animator A;


     public ControlCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 setScales(650,350,100);
	 CONTROL=new ListenSquare(0,0,300,899);
	 SLIDER=new ListenSquare(200,0,99,699);
	 DEGREE=new SelectInteger(10,20,60,30,3,1,10,1);
	 RANGE=new SelectInteger(10,650,60,30,3,0,20,1);
	 SPEED=new SelectInteger(10,520,60,30,5,-5,15,1);
	 for(int i=0;i<10;++i) {
	     COEFF[i][0]=new SelectInteger(2,80+35*i,40,20,0,-20,20,1);
	     COEFF[i][1]=new SelectInteger(82,80+35*i,40,20,0,-20,20,1);
	 }
	 INPUT=1;
	 COEFF[1][0].val=1;
	 COEFF[2][0].val=1;
	 GO=new ListenSquare(10,580,40,20);
	 STOP=new ListenSquare(80,580,40,20);
	 A=new Animator();
     }

   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      drawRange(g);  
      drawControls(g);  
      drawInput(g);
      drawMarkings(g);
   }


    public void drawRange(Graphics2D g) {
	GeneralPath gp=new GeneralPath();
	double D=1024;
	double r=INPUT;
	double max=.1;
	for(int i=0;i<D;++i) {
	    double t=2.0*Math.PI*i/D;
	    double c=r*Math.cos(t);
	    double s=r*Math.sin(t);
	    Complex z=new Complex(c,s);
	    z=getImage(z);
	    c=z.x;
	    s=z.y;
	    double cc=Math.abs(c);
	    double ss=Math.abs(s);
	    if(max<cc) max=cc;
	    if(max<ss) max=ss;
	    if(i==0) gp.moveTo((float)(c),(float)(s));
	    if(i!=0) gp.lineTo((float)(c),(float)(s));
	}



	setScales(650,350,300/max);
	drawBack(g);
	gp=transform(gp);
	g.setColor(Color.white);
	g.setStroke(new BasicStroke(2));
	g.draw(gp);
	g.setStroke(new BasicStroke(1));
    }


    public void drawBack(Graphics2D g) {
	GeneralPath gp=new GeneralPath();
	gp.moveTo(300,350);
	gp.lineTo(1000,350);
	gp.moveTo(650,0);
	gp.lineTo(650,700);
	g.setColor(Color.red);
	g.draw(gp);
	double r=.01;
	g.setColor(new Color(0,0,255));
	for(int i=0;i<20;++i) {
	    gp.reset();
	    gp.moveTo((float)(0-r),(float)(0-r));
	    gp.lineTo((float)(0+r),(float)(0-r));
	    gp.lineTo((float)(0+r),(float)(0+r));
	    gp.lineTo((float)(0-r),(float)(0+r));
	    gp.closePath();
	    gp=transform(gp);
	    g.draw(gp);
	    r=2*r;
	}
    }





    public void drawControls(Graphics2D g) {

	CONTROL.render(g,new Color(0,0,120));  
	GO.render(g,new Color(0,140,0));
	if(A.HALT==false) STOP.render(g,Color.red);
	SLIDER.render(g,new Color(100,0,255));  
	Color C=new Color(0,0,0,0);	
        RANGE.render2(g,new Color(0,130,0),Color.white,Color.white);
        SPEED.render(g,new Color(0,130,180),Color.white,Color.white);
        DEGREE.render(g,Color.red,Color.white,C);
	for(int i=0;i<DEGREE.val;++i) {
            COEFF[i][0].render(g,Color.blue,Color.white,Color.white);
            COEFF[i][1].render(g,Color.blue,Color.white,Color.white);
	    Integer I=new Integer(i); 
            g.setFont(new Font("Helvetica",Font.PLAIN,16));
	    if(i==0) g.drawString("+",155,100+35*i);
	    if(i>0) {
                g.drawString("z",155,100+35*i);
		if(i>1) g.drawString(I.toString(),165,90+35*i); 
                if(i<DEGREE.val-1) g.drawString("+",180,100+35*i);
	    }
	}
    }


    public void drawMarkings(Graphics2D g) {
       g.setFont(new Font("Helvetica",Font.PLAIN,16));
       g.setColor(Color.white);
       Integer I=new Integer(DEGREE.val-1);
       g.drawString("degree "+I.toString(),80,40);
       g.drawString("speed",(int)(SPEED.x+5),(int)(SPEED.y-10));
       g.drawString("go",(int)(GO.x+5),(int)(GO.y+15));
       if(A.HALT==false)
       g.drawString("stop",(int)(STOP.x+5),(int)(STOP.y+15));
       g.drawString("range",(int)(RANGE.x+5),(int)(RANGE.y-10));
       g.setColor(new Color(50,0,100));
       g.drawString("radius",210,25);
       Double D=new Double(INPUT);
       String S=D.toString();
       if(S.length()>8) S=S.substring(0,8);
       g.drawString(S,210,45);



    }


    public void drawInput(Graphics2D g) {
	double t1=Math.pow(2,RANGE.val);
	double t2=700;
	double t3=t2*INPUT/t1;
	GeneralPath gp=new GeneralPath();
	gp.moveTo(200,(float)(t3));
	gp.lineTo(299,(float)(t3));
	g.setColor(Color.white);
	g.fill(gp);
	g.draw(gp);
    }

    public void modifyPoly(Point X) {
	DEGREE.modify(X);
	for(int i=0;i<10;++i) {
	    COEFF[i][0].modify(X);
	    COEFF[i][1].modify(X);
	}
    }



    public Complex getImage(Complex z) {
	int d=DEGREE.val;
	Complex w=new Complex(0,0);
	Complex mono=new Complex(0,0);
	for(int i=0;i<d;++i) {
	    mono=z.pow(i);
	    Complex c=new Complex(COEFF[i][0].val,COEFF[i][1].val);
	    mono=Complex.times(c,mono);
	    w=Complex.plus(w,mono);
	}
	return(w);
    }



    public void setRange(Point X) {
	RANGE.modify(X);
	if(SLIDER.inside(X)==1) {
	    double t3=X.y;
	    double t1=Math.pow(2,RANGE.val);
	    double t2=700;
	    INPUT=t3*t1/t2;
	}
    }

    public void doRun() {
	if(A.HALT==true) {
	    A=new Animator(this);
	    new Thread(A).start();
	}
    }

    public void doStop() {
	A.HALT=true;
    }
    
    public void mouseClicked(MouseEvent e) {
        MouseData J=MouseData.process(e);
	if(CONTROL.inside(J.X)==0) {
	  if(J.mode==1) scaleUp(J.X,-1);
	  if(J.mode==3) scaleUp(J.X,1);
	}
	else {
	    modifyPoly(J.X);
	    setRange(J.X);
	    SPEED.modify(J.X);
	    if(GO.inside(J.X)==1) doRun();
	    if(STOP.inside(J.X)==1) doStop();
	}
	repaint();
    }

    public void mouseDragged(MouseEvent e) {
        MouseData J=MouseData.process(e);
	setRange(J.X);
	repaint();
    }

    public void mousePressed(MouseEvent e) {}
     public void mouseReleased(MouseEvent e) {}
     public void mouseEntered(MouseEvent e) {}
     public void mouseExited(MouseEvent e) {}   
     public void mouseMoved(MouseEvent e) {}    


}

