import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.math.*;

public class BigRational {
    BigInteger P;
    BigInteger Q;

    public BigRational() {}

    public BigRational(long p,long q) {
	Long pp=new Long(p);
	Long qq=new Long(q);
	P=new BigInteger(pp.toString());
	Q=new BigInteger(qq.toString());
    }


    public BigRational(BigRational R) {
	P=new BigInteger(R.P.toString());
	Q=new BigInteger(R.Q.toString());
    }


    public BigRational(BigInteger P0,BigInteger Q0) {
	P=new BigInteger(P0.toString());
	Q=new BigInteger(Q0.toString());
    }

    public BigRational(String p,String q) {
	P=new BigInteger(p);
	Q=new BigInteger(q);
    }


    public BigRational add(BigRational X) {
	BigRational Y=new BigRational();
	Y.Q=Q.multiply(X.Q);
	Y.P=P.multiply(X.Q);
	Y.P=Y.P.add(Q.multiply(X.P));
	Y.reduce();
	return(Y);
    }


    public BigRational average(BigRational X) {
	BigRational Y=this.add(X);
	Y.Q=Y.Q.multiply(new BigInteger("2"));
	Y.reduce();
	return(Y);
    }


    public BigRational subtract(BigRational X) {
	BigRational Y=new BigRational();
	Y.Q=Q.multiply(X.Q);
	Y.P=P.multiply(X.Q);
	Y.P=Y.P.subtract(Q.multiply(X.P));
	Y.reduce();
	return(Y);
    }

    public BigRational multiply(BigRational X) {
	BigRational Y=new BigRational();
	Y.Q=Q.multiply(X.Q);
	Y.P=P.multiply(X.P);
	Y.reduce();
	return(Y);
    }
    public BigRational divide(BigRational X) {
	BigRational Y=new BigRational();
	Y.Q=Q.multiply(X.P);
	Y.P=P.multiply(X.Q);
	Y.reduce();
	return(Y);
    }

    public void reduce() {
	BigInteger C=P.gcd(Q);
	P=P.divide(C);
	Q=Q.divide(C);
    }

    public boolean equals(BigRational A) {
	BigRational B=this.subtract(A);
	if(B.isZero()==true) return true;
	return false;
    }

    public boolean isZero() {
	if(P.signum()==0) return true;
	return false;
    }

    public boolean isPositive() {
	int a=P.signum()*Q.signum();
	if(a==1) return true;
	return false;
    }

    public boolean isNegative() {
	int a=P.signum()*Q.signum();
	if(a==-1) return true;
	return false;
    }

    public BigRational invert() {
	BigRational Y=new BigRational(Q,P);
	return(Y);
    }

    public BigRational negate() {
	BigRational Z=new BigRational(0,1);
	return Z.subtract(this);
    }


    public static BigRational min(BigRational x,BigRational y) {
	BigRational z=x.subtract(y);
	if(z.isNegative()==true) return x;
	return y;
    }


    public static BigRational max(BigRational x,BigRational y) {
	BigRational z=x.subtract(y);
	if(z.isNegative()==true) return y;
	return x;
    }

    /**Some special functions*/



    public static BigRational power(BigRational S,int k) {
	if(k>=0) return powerBasic(S,k);
	BigRational X=powerBasic(S,-k);
	X=X.invert();
	return(X);
    }


    public static BigRational powerBasic(BigRational S,int k) {
	BigRational R=new BigRational(1,1);
	for(int i=0;i<k;++i) R=R.multiply(S);
	return(R);
    }

    public static BigRational factorial(int k) {
	BigRational R=new BigRational(1,1);
	for(int i=1;i<=k;++i) {
	    BigRational S=new BigRational(i,1);
            R=R.multiply(S);
	}
	return(R);
    }

    public static BigRational choose(int n,int k) {
	BigRational R1=factorial(n);
	BigRational R2=factorial(k);
	BigRational R3=factorial(n-k);
	BigRational S=R1.divide(R2.multiply(R3));
	return S;
    }

    /**conversion and printing*/

    public double toDouble() {
	BigDecimal c=this.toBigDecimal(30);
	return c.doubleValue();
    }

    public BigDecimal toBigDecimal(int k) {
	BigDecimal X=new BigDecimal(P);
	BigDecimal Y=new BigDecimal(Q);
	X=X.divide(Y,k,BigDecimal.ROUND_HALF_DOWN);
	return(X);
    }

    public void print() {
	System.out.print(P.toString()+"/"+Q.toString());
    }

    public void println() {
	System.out.println(P.toString()+"/"+Q.toString());
    }

    public void printN() {
	BigDecimal D=this.toBigDecimal(30);
	String S=D.toString();
	System.out.print(S);
    }

    public void printlnN() {
	BigDecimal D=this.toBigDecimal(30);
	String S=D.toString();
	System.out.println(S);
    }

}


    

