import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.math.*;



public class ComputeCombo6 {

    public static double[] getTarget(double[] A,double s) {
	double a2=A[0];
	double a3=A[1];
	double a4=A[2];
	double[] T={SpecialFunctions.R(s,a2),SpecialFunctions.R(s,a3),
                    SpecialFunctions.R(s,a4),SpecialFunctions.dR(s,a2),
                   SpecialFunctions.dR(s,a3),SpecialFunctions.dR(s,a4)};
	return T;
    }


    /**This is the main routine.  It gets the coefficients
       a0,a1,a2,a3,a4,a5 of the interpolation*/

    public static double[] coeffList(EnergyCombo[] d,double[] A,double s) {
	Matrix M=new Matrix();
	M.size=6;
	double a2=A[0];
	double a3=A[1];
	double a4=A[2];
	for(int i=0;i<6;++i) {
	    M.m[i][0]=SpecialFunctions.G(d[i],a2);
	    M.m[i][1]=SpecialFunctions.G(d[i],a3);
	    M.m[i][2]=SpecialFunctions.G(d[i],a4);
	    M.m[i][3]=SpecialFunctions.dG(d[i],a2);
	    M.m[i][4]=SpecialFunctions.dG(d[i],a3);
	    M.m[i][5]=SpecialFunctions.dG(d[i],a4);
	}

	M=Matrix.inverse(M);
	if(M==null) return null;
	double[] T=getTarget(A,s);
	double[] e=new double[6];
	for(int i=0;i<6;++i) {
	    for(int j=0;j<6;++j) {
		e[i]=e[i]+M.m[j][i]*T[j];
	    }
	}
	return e;
    }


    /**This gets the value of the linear combination*/

    public static double cone(double[] a,EnergyCombo[] b,double x) {
	if(a==null) return 0;
	if(b==null) return 0;
	double t=0;
	for(int i=0;i<6;++i) t=t+a[i]*SpecialFunctions.G(b[i],x);
	return t;
    }

}



