import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class ControlCanvas extends ScaleCanvas implements MouseListener, KeyListener {
    AffineTransform A;
    Manager M;
    HSlider EXP,FP;
    Lever CHOICE,PRESET;
    ListenSquare[] FUNCTION;
    ControlPanel MAIN,PROOF1,DEBUG,ADVANCED;
    SelectInteger[] RANGE=new SelectInteger[2];
    EnergyCombo[] ENG=new EnergyCombo[6];
    ListenSquare GO,HALT;
    TestPosdom1 TP1;
    TestPosdom2 TP2;
    Debug DEB;
    PopupManager PM;
    PosdomMonitor POSM;
    ListenSquare INFO1,INFO2,INFO3,INFO4;

     public ControlCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 addKeyListener(this);
	 setActionControls();
	 setEnergyControls();
	 setFunctionControls();	
	 ControlPanelSetup.main(this);
	 PM=new PopupManager(this.M,145,381);
	 POSM=new PosdomMonitor(this.M,210,209,260,260);
	 INFO1=new ListenSquare(325,35,12,12);
	 INFO2=new ListenSquare(444,132,12,12);
	 INFO3=new ListenSquare(0,20,15,15);
	 INFO4=new ListenSquare(144,365,12,12);

    }


    public void setActionControls() {
	 GO=new ListenSquare(0,370,30,30);
	 HALT=new ListenSquare(30,370,40,30);
	 TP1=new TestPosdom1();
	 TP2=new TestPosdom2();
	 DEB=new Debug();
    }


    public void setEnergyControls() {
         Color[] C1={new Color(200,0,0),Color.white,Color.white};
	 Color[] C2={new Color(0,0,200),Color.white,Color.white};
	 EXP=new HSlider(0,0,470,20,200,C1,"exponent");
	 FP=new HSlider(0,184,470,22,250,C2,"FP parameter");
	 int[] p={50,100,200,300};
	 String[] S={"0","1","2","3","7","12"};
	 for(int i=0;i<6;++i) ENG[i]=new EnergyCombo(35+25*i,"");
	 PresetData.preset5(ENG);
    }

    public void setFunctionControls() {
	CHOICE=new Lever(345,50,0,2);
	 PRESET=new Lever(345,130,0,6);
	 RANGE[0]=new SelectInteger(5,425,35,20,-2,-2,16,1);
	 RANGE[1]=new SelectInteger(78,425,35,20,0,-2,16,1);
    }


   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
            RenderingHints.VALUE_ANTIALIAS_ON);
       drawFrame(g);
       drawControls(g);
   }

    public void drawFrame(Graphics2D g) {
	g.setColor(new Color(60,80,100));
	g.fillRect(0,0,getWidth(),getHeight());
	g.setColor(new Color(100,0,100));
	g.fillRect(0,209,205,260);
	g.setColor(Color.white);
	g.drawRect(0,209,205,260);
	PM.render(g);
	INFO1.infoRender(g);
	INFO2.infoRender(g);
	INFO3.infoRender(g);
	INFO4.infoRender(g);
    }

    
    public void drawControls(Graphics2D g) {
	MAIN.render(g,0,209,80);
	ADVANCED.render(g,0,279,80);
	if(MAIN.mode==0) PROOF1.render(g,85,209,120);
	if(MAIN.mode==2) DEBUG.render(g, 85,209,120);

	EXP.render(g);
	double d=EXP.getValue();
	d=-2*(1-d)+16*d;
	Double D=new Double(d);
	g.setColor(Color.white);  
        g.setFont(new Font("Helvetica",Font.PLAIN,14));
	g.drawString(D.toString(),70,16);
	g.setColor(new Color(255,150,0));
	g.drawString("click/drag to change exponent",240,16);

	if(CHOICE.val==1) {
          FP.render(g);
	  D=new Double(.1+FP.getValue()/4);	
	  g.setColor(Color.white);  
          g.drawString(D.toString(),170,FP.y+16);
	}


	drawGo(g);
	drawHalt(g);
	drawComboControl(g);
	drawRange(g);
	if(MAIN.mode==1) POSM.render(g);
    }

    public void drawRange(Graphics2D g) {
	for(int i=0;i<2;++i) 
        RANGE[i].render(g,Color.red,Color.white,Color.white);
	g.drawString("posdom test domain",10,460);
	g.drawString("min",14,420);
	g.drawString("max",85,420);
    }

    public void drawComboControl(Graphics2D g) {
	Color[] C=PresetData.colorScheme();
	for(int i=0;i<6;++i) ENG[i].render(g,C[i]);
    }



    public void drawGo(Graphics2D g) {
	if(TP1.HALT==false) return;   
	if(TP2.HALT==false) return;   
        g.setFont(new Font("Helvetica",Font.PLAIN,18));
	GO.render(g,new Color(0,150,0));
	g.drawString("go",(int)(GO.x+4),(int)(GO.y+20));
    }

    public void drawHalt(Graphics2D g) {
	boolean running=false;
	if(TP1.HALT==false) running=true;
	if(TP2.HALT==false) running=true;
	if(DEB.HALT==false) running=true;
	if(running==false) return;
        g.setFont(new Font("Helvetica",Font.PLAIN,18));
	HALT.render(g,new Color(200,0,0));
	g.drawString("stop",(int)(HALT.x+4),(int)(HALT.y+20));
    }


    public void doHalt() {
	TP1.HALT=true;
	TP2.HALT=true;
	DEB.HALT=true;
    }

    public void doGo() {
	if(TP1.HALT==false) return;
	if(TP2.HALT==false) return;
	int mode=MAIN.mode;
	if(mode==0) doGo1();
	if(mode==1) doGo2();
	if(mode==2) doGo3();
    }

    public void doGo1() {
        TP1=new TestPosdom1(this.M);
        new Thread(TP1).start();
    }

    public void doGo2() {
	TP2=new TestPosdom2(this.M);
        new Thread(TP2).start();
    }

    public void doGo3() {
	DEB=new Debug(this.M);
        new Thread(DEB).start();
    }



    public void mouseClicked(MouseEvent e) {
        MouseData J=MouseData.process(e);
	for(int i=0;i<6;++i) ENG[i].process(e);
	for(int i=0;i<2;++i) RANGE[i].modify(J.X);
	EXP.modify(J.X);
	if(MAIN.mode==0) PROOF1.switchMode(J.X);
	if(MAIN.mode==2) DEBUG.switchMode(J.X);
	MAIN.switchMode(J.X);
	PM.M=this.M;
	PM.process(J.X);
	if(GO.inside(J.X)==1) doGo();
	if(HALT.inside(J.X)==1) doHalt();
	resetDebug();
	documentStuff(J.X);
	doTest();
	M.repaint();
    }

    public void doTest() {

    }

  public void documentStuff(Point X) {
      if(MAIN.L[20].inside(X)==1) DocumentControl.test(M.D);
      if(INFO1.inside(X)==1) DocumentControl.compete(M.D);
      if(INFO3.inside(X)==1) DocumentControl.combo(M.D);
      if(INFO4.inside(X)==1) DocumentControl.popups(M.D);
      if(ADVANCED.L[20].inside(X)==1) DocumentControl.advanced(M.D);
      if(DEBUG.L[20].inside(X)==1) DocumentControl.debug(M.D);
      if((MAIN.mode==0)&&(PROOF1.L[20].inside(X)==1))  DocumentControl.mode1(M.D);
    }


    public double[] getTarget() {
	if(CHOICE.val==0) {
	   double[] A={Math.sqrt(2),Math.sqrt(3),2};
	   return A;
	}
	double t=.1+FP.getValue()/4;
	double a0=Math.sqrt(2-2*t*t);
	double a1=Math.sqrt(2*(1+t));
	double a2=2*Math.sqrt(1-t*t);
	double[] A={a0,a1,a2};
	return A;
    }


    public double getExponent() {
	double d=EXP.getValue();
	double e=-2*(1-d)+16*d;
	return e;
    }


    public void mouseDragged(MouseEvent e) {
        MouseData J=MouseData.process(e);
	EXP.modify(J.X);
	FP.modify(J.X);	
        resetDebug();
	M.repaint();
    }

    public void mousePressed(MouseEvent e) {}
     public void mouseReleased(MouseEvent e) {}
     public void mouseEntered(MouseEvent e) {}
     public void mouseExited(MouseEvent e) {}   

    public void keyTyped(KeyEvent e) {
	for(int i=0;i<6;++i) {
	  ENG[i].processKey(e);
	}
	M.repaint();
    }
 
    public void keyPressed(KeyEvent e) {}
    public void keyReleased(KeyEvent e) {}

    public void resetDebug() {
	try {
	    M.P.DEBUG1=null;
	    M.P.DEBUG2=null;
	    M.P.repaint();
	}
	catch(Exception e) {}
    }

}

