import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

/**Documentation file*/


public class DocumentIntro {

    public DocumentIntro() {}


    public static void setup(DocumentCanvas D) {
    
	String S="The Energy Combo Analyzer\n\n";
        S=S+"Richard Evan Schwartz\n";
	S=S+"program started: 1 July 2016\n";
	S=S+"Last updated:  7 Aug 2016\n";


	S=S+"\n\nPURPOSE:\n\n";
	S=S+"This program is a companion to my paper called `The Triangular Bi-Pyramid is the Minimizer for Many Riesz Potentials'.  The program allows you to run the proofs of the results in Chapter 8 in the paper.  These are the under approximation results.  The basic idea is that we can select 5 energy combos (defined in the paper) and we want to see that a suitable linear combination of them under-approximates a power law potential.";

	    S=S+"\n\nOPERATING INSTRUCTIONS\n\n";

	    S=S+"This window gives explanations for the rest of the program.  Drag the mouse over the text to scroll up or down. (There is more text than what is now visible.) The text in this window will change if you press some of the black ?-boxes sprinkled throughout the rest of the program. If you want to return this text, press the black ?-box at top left.";

	    S=S+"\n\nWhen this program opens, it shows two windows, this one and a control panel.  On the control panel, there is a console which allows you to bring up  two additional windows, called `Approx' and 'Coeffs'.  You should try bringing these windows up, then deleting them, then bringing them up again, just to see how this control works. These windows have their own documentation.";


	    S=S+"\n\nThis program is designed to work best with a 3 button mouse. On the picture window, buttoms 1 and 3 zoom in and out of the picture and button 2 selects a new point. If you don't have a 3 button mouse, you can use the keyboard buttons z,x,c or the buttons b,n,m to simulate the 3 buttons when you are operating any of the windows where you might want to rescale the picture.";

	    S=S+"\n\nOVERVIEW OF THE WINDOWS:";

	    S=S+"\n\ncontrol panel: This is the window from which you launch the programs. You should click the ?-boxes to learn more about what it does.  The main thing the window does is allow you to select 5 energy combos, e.g. \n\nG0 (the function that is identically 1)\n\n G1\n\nG2\n\nG5\n\nG10+28G5+102G2\n\nIf this doesn't make sense to you then you should read the introduction to the paper first.";

	    S=S+"\n\ndocument: This is the window you are currently looking at.";

	    S=S+"\n\nApprox: This window plots the function\n\n(+/-)(\u0393/F-1)\n\n from Chapter 8. We want this function to be non-negative on [0,2].  We also scale the range of the plot so that it fits nicely in the window.";

	    S=S+"\n\nCoeff: This window plots the coefficients of the energy combo you pick.  The idea here is that we want to get positive combinations of the 5 energy combos.  You can pick an energy combo and then the window shows a plot of the coefficients versus the exponent of the power law.";

	    S=S+"\n\nNOTE:";

		S=S+"\n\nThis program has an advanced mode and a basic mode.  The advanced mode allows you to do stuff that is not described in the paper and not documented here. All the documentation here pertains to the simple mode.";

        D.setExplain(S);
        D.repaint();   
	D.Y0=0;
        D.Y1=0;
    }
}

