import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.math.*;

/**A monomial is an expression of the form 

c x0^{e0}x1^{e1}

here c is a BigRational and
e0,e1 are non-negative integer exponents.  We
keep track of c and e0,e1*/

public class Mono2 {
    BigRational c;
    int[] e=new int[2];

    public Mono2() {}

    public Mono2(Mono2 a) {
	this.c=new BigRational(a.c);
	for(int i=0;i<2;++i) this.e[i]=a.e[i];
    }

    public Mono2(int p,int q,int[] ee) {
	this.c=new BigRational(p,q);
	for(int i=0;i<2;++i) e[i]=ee[i];
    }

    public Mono2(BigRational cc,int[] ee) {
	this.c=new BigRational(cc);
	for(int i=0;i<2;++i) e[i]=ee[i];
    }

    public Mono2(BigRational cc,int i,int j) {
	int[] ee={i,j};
	this.c=new BigRational(cc);
	e[0]=i;
	e[1]=j;
    }

    /**permutes the coefficients by a cyclic permutation*/

    public Mono2 rotate(int r) {
	Mono2 m=new Mono2();
	m.c=new BigRational(this.c);
	for(int i=0;i<2;++i) {
	    int j=(i+2+r)%2;
	    m.e[j]=e[i];
	}
	return(m);
    }

    public Mono2 negate() {
	Mono2 m=new Mono2();
	m.c=this.c.negate();
	m.e[0]=e[0];
	m.e[1]=e[1];
	return(m);
    }

    public int degree() {
	int d=0;
	for(int i=0;i<2;++i) d=d+e[i];
	return d;
    }

    public static Mono2 times(Mono2 A,Mono2 B) {
	Mono2 C=new Mono2();
	C.c=A.c.multiply(B.c);
	for(int i=0;i<2;++i) C.e[i]=A.e[i]+B.e[i];
	return(C);
    }

    public double evaluate(double[] x) {
	BigDecimal C0=c.toBigDecimal(20);
	double C1=C0.doubleValue();
	for(int i=0;i<2;++i) {
	    double a=Math.pow(x[i],e[i]);
	    C1=C1*a;
	}
	return(C1);
    }

    public BigRational evaluate(BigRational[] x) {
	BigRational a0=BigRational.power(x[0],e[0]);
	BigRational a1=BigRational.power(x[1],e[1]);
	BigRational b=a0.multiply(a1.multiply(c));
	return b;
    }
    
    /**printouts*/
    public void print() {
	System.out.print("{");
	c.print();
	System.out.print(",");
	for(int i=0;i<2;++i) {
	    System.out.print(e[i]);
	    if(i<1) System.out.print(",");
	}
	System.out.print("}");
    }

    public void println() {
	this.print();
	System.out.println("");
    }

    public void printN() {
	c.printN();
	System.out.print(",");
	for(int i=0;i<2;++i) {
	    System.out.print(e[i]+" ");
	}
	System.out.println("");
    }


}




