import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.math.*;

/**This is a single variable polynomial*/

public class Poly1 {
    BigRational[] C=new BigRational[50];
    BigRational LEFT;
    BigRational RIGHT;
    int degree;
    int age;

    public Poly1() {
	degree=0;
	for(int i=0;i<50;++i) C[i]=new BigRational(0,1);
	age=0;
    }

    public Poly1(Poly1 P) {	
        for(int i=0;i<50;++i) C[i]=new BigRational(0,1);
	this.degree=P.degree;
	for(int i=0;i<=degree;++i) this.C[i]=new BigRational(P.C[i]);
	this.age=P.age;
	try{this.LEFT=new BigRational(P.LEFT);
	    this.RIGHT=new BigRational(P.RIGHT);}
	catch(Exception e) {}
    }

    public Poly1(BigRational[] c) {
	this.degree=c.length-1;
	for(int i=0;i<50;++i) this.C[i]=new BigRational(0,1);
	for(int i=0;i<c.length;++i) {
            this.C[i]=new BigRational(c[i]);
	}
    }

    /**This sets the degree in case some leading coefficients
       have become 0*/

    public void fixDegree() {
	int test=0;
	for(int i=0;i<=degree;++i) {
	    if(C[i].isZero()==false) test=i;
	}
	degree=test;
    }

    public Poly1 scale(BigRational R) {
	Poly1 P=new Poly1();
	P.degree=this.degree;
	for(int i=0;i<=degree;++i) {
	    P.C[i]=this.C[i].multiply(R);
	}
	return P;
    }

    public Poly1 add(Poly1 A) {
	Poly1 P=new Poly1();
	P.degree=this.degree;
	if(P.degree<A.degree) P.degree=A.degree;
	for(int i=0;i<=P.degree;++i) {
	    P.C[i]=this.C[i].add(A.C[i]);
	}
	P.fixDegree();
	return P;
    }

    public Poly1 subtract(Poly1 A) {
	Poly1 P=new Poly1();
	P.degree=this.degree;
	if(P.degree<A.degree) P.degree=A.degree;
	for(int i=0;i<=P.degree;++i) {
	    P.C[i]=this.C[i].subtract(A.C[i]);
	}
	P.fixDegree();
	return P;
    }

    Poly1 multiply(Poly1 A) {
	Poly1 B=new Poly1();
	B.degree=this.degree+A.degree;
	for(int m=0;m<=B.degree;++m) {
	    BigRational R=new BigRational(0,1);
	    for(int i=0;i<=m;++i) {
		R=R.add(C[i].multiply(A.C[m-i]));
	    }
	    B.C[m]=new BigRational(R);
	}
	return B;
    }



    /** NEW(x) = x OLD(x)*/

    public void shiftUp() {
	++degree;
	for(int i=degree;i>0;--i) {
	    this.C[i]=new BigRational(this.C[i-1]);
	}
	this.C[0]=new BigRational(0,1);
    }



    /**positive dominance test*/

    public boolean isPositiveDominant() {
	BigRational R=new BigRational(0,1);
	for(int i=0;i<=this.degree;++i) {
	    R=R.add(C[i]);
	    if(R.isNegative()==true) return false;
	}
	return true;
    }

    /**subdivisions for the positive dominance algorithm*/


    public Poly1 sub1() {
	Poly1 P=this.dilate();
	P.LEFT=this.LEFT;
	P.RIGHT=this.RIGHT.average(this.LEFT);
	P.degree=this.degree;
	P.age=this.age+1;
	return(P);
    }

    public Poly1 sub2(boolean mode) {
	Poly1 P=this.reverse();
	P=P.dilate();
	if(mode==true) P=P.reverse();
	P.degree=this.degree;
	P.age=this.age+1;
	return P;
    }

    /**NEW(x)=OLD(x/2)*/

    public Poly1 dilate() {
	BigRational HALF=new BigRational(1,2);
	Poly1 P=this.dilate(HALF);
	P.RIGHT=this.RIGHT;
	P.LEFT=this.LEFT.average(this.RIGHT);
	return P;
    }

    public Poly1 dilate(BigRational T) {
	Poly1 P=new Poly1();
	P.degree=this.degree;
	for(int i=0;i<=P.degree;++i) {
	    P.C[i]=this.C[i].multiply(BigRational.power(T,i));
	}
	return P;
    }

    /**NEW(x)=OLD(1-x)*/


    public Poly1 reverse() {
	Poly1 P=new Poly1();
	int n=this.degree;
	for(int i=0;i<=n;++i) {
	    Poly1 Q=reverse(i);
	    Q=Q.scale(C[i]);
	    P=P.add(Q);
	}
	P.LEFT=new BigRational(this.LEFT);
	P.RIGHT=new BigRational(this.RIGHT);
	return P;
    }

    public static Poly1 reverse(int k) {
	BigRational[] R={new BigRational(1,1),new BigRational(-1,1)};
	Poly1 P=new Poly1(R);
	Poly1 Q=new Poly1();
	Q.degree=0;
	Q.C[0]=new BigRational(1,1);
	for(int i=0;i<k;++i) {
	    Q=Q.multiply(P);
	}
	Q.degree=k;
	return(Q);
    }

    public boolean outsideRange(BigRational LO) {
	BigRational L=LEFT.subtract(LO);
	BigRational R=RIGHT.subtract(LO);
	boolean test=false;
	if(L.isPositive()==true) test=true;
	if(R.isPositive()==true) test=true;
	if(test==true) return false;
	return true;
    }

    /**Evaluation*/
    public BigRational evaluate(BigRational t) {
	BigRational tot=new BigRational(0,1);
	for(int i=0;i<=degree;++i) {
	    BigRational t1=BigRational.power(t,i);
	    t1=t1.multiply(C[i]);
	    tot=tot.add(t1);
	}
	return tot;
    }

    /**for debugging purposes*/
    public double evaluate(double t) {
	double tot=0;
	for(int i=0;i<=degree;++i) {
	    double t1=Math.pow(t,i);
	    t1=t1*C[i].toDouble();
	    tot=tot+t1;
	}
	return tot;
    }

    public static Poly1 min(Poly1 A,Poly1 B) {
	Poly1 X=new Poly1(A);
	for(int i=0;i<50;++i) 
        X.C[i]=BigRational.min(A.C[i],B.C[i]);
	return X;
    }

    public static Poly1 max(Poly1 A,Poly1 B) {
	Poly1 X=new Poly1(A);
	for(int i=0;i<50;++i) 
        X.C[i]=BigRational.max(A.C[i],B.C[i]);
	return X;
    }

    /**end subdivision methods*/

    public void print() {
	System.out.println("-------------------");
	for(int i=0;i<=degree;++i) {
	    C[i].print();
	    System.out.print(" x^"+i);
	    if(i<degree) System.out.println(" + ");
	    if(i==degree) System.out.println("");
	}
	System.out.println("-------------------");
    }


    public void printN() {
	System.out.println("-------------------");
	for(int i=0;i<=degree;++i) {
	    C[i].printN();
	    System.out.print(" x^"+i);
	    if(i<degree) System.out.println(" + ");
	    if(i==degree) System.out.println("");
	}
	System.out.println("-------------------");
    }

    public void printSign() {
	System.out.println("-------------------");
	for(int i=0;i<=degree;++i) {
	    if(C[i].isNegative()==true) System.out.print("[-] ");
	    if(C[i].isPositive()==true) System.out.print("[+] ");
	    if(C[i].isZero()==true) System.out.print("[0] ");
	    System.out.print(" x^"+i);
	    if(i<degree) System.out.println(" + ");
	    if(i==degree) System.out.println("");
	}
	System.out.println("-------------------");
    }


    /**For the positive dominance algorithm*/
    public void printEndpoints() {
	System.out.print("[");
	LEFT.print();
	System.out.print("  ");
	RIGHT.print();
	System.out.println("]");
    }
}


    

