import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class PopupManager {
    Manager M;
    int X,Y;
    ListenSquare COEFF,PICTURE,DOC;

    /**This class appears as a list of 3 buttons
       on the control panel.  It lets you launch
       the various popup windows from the control
       panel*/

    public PopupManager(Manager m,int x,int y) {
	M=m;
	this.X=x;
	this.Y=y;
	PICTURE=new ListenSquare(X,Y+22,60,22);
	COEFF=new ListenSquare(X,Y+44,60,22);
	DOC=new ListenSquare(X,Y+66,60,22);
    }


    public void render(Graphics2D g) {
	g.setColor(Color.black);
	g.fillRect(X,Y,60,88);
	g.setColor(Color.white);
	g.drawRect(X,Y,60,88);
	COEFF.render(g,new Color(200,0,200));
	PICTURE.render(g,new Color(0,0,200));
	DOC.render(g,new Color(0,150,150));
        g.setFont(new Font("Helvetica",Font.PLAIN,14));
	g.setColor(Color.white);
	g.drawString("popups",X+7,Y+16);
        g.setFont(new Font("Helvetica",Font.PLAIN,13));
	g.drawString("approx",X+5,Y+39);
	g.drawString("coeffs",X+5,Y+61);
	g.drawString("info",X+5,Y+83);
    }

    public void process(Point X) {

	if(PICTURE.inside(X)==1) {
	    PopupPictureCanvas PP=new PopupPictureCanvas();
	    PP.P.M=this.M;
	    M.P=PP.P;
	    M.repaint();
	}

	if(COEFF.inside(X)==1) {
	    PopupCoeffCanvas PX=new PopupCoeffCanvas();
	    PX.X.M=this.M;
	    M.X=PX.X;
	    M.repaint();
	}

	if(DOC.inside(X)==1) {
	    PopupDocumentCanvas PD=new PopupDocumentCanvas();
	    PD.D.M=this.M;
	    M.D=PD.D;
	    M.repaint();
	}

    }




}

