import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class PosdomMonitor {
    Manager M;
    int X,Y,W,H;
    Path2D.Double[] P=new Path2D.Double[20000];
    int count;
    Color[] COL1=new Color[20000];
    Color[] COL2=new Color[20000];
    int HISTORY;
    Integer[] I=new Integer[2];

    public PosdomMonitor() {}

    public PosdomMonitor(Manager m,int x,int y,int w,int h) {
	this.M=m;
	X=x;
	Y=y;
	W=w;
	H=h;
	HISTORY=0;
    }

    public void render(Graphics2D g) {
	g.setColor(Color.black);
	g.fillRect(X,Y,W,H);
	g.setColor(Color.white);
	g.drawRect(X,Y,W,H);
	g.setColor(new Color(100,100,100));
	for(int i=0;i<count;++i) {
	    g.setColor(COL1[i]);
	    g.fill(P[i]);
	    g.setColor(COL2[i]);
	    g.draw(P[i]);
	}
        g.setFont(new Font("Helvetica",Font.PLAIN,50));
	g.setColor(new Color(255,255,255,150));
	if(I[0]==null) return;
	if(I[1]==null) return;
	String S="["+I[0].toString()+","+I[1].toString()+"]";
	g.drawString(S,X+7,Y+H-17);
    }


    public void accept(int k0,int k1) {
	if(k1==0) {
	    I[0]=new Integer(k0-1);
	    I[1]=new Integer(k0);
	}
	if(k1==1) {
	    I[0]=new Integer(k0);
	    I[1]=new Integer(k0+1);
	}
    }

    public void accept(BigRational[][] A,int k0,int k1) {
	if(k1==0) COL1[count]=Color.red;
	if(k1==1) COL1[count]=Color.blue;
	if(k1==0) COL2[count]=Color.white;
	if(k1==1) COL2[count]=Color.white;
	process(A,k0,k1);
    }
    public void reject(BigRational[][] A,int k0,int k1) {
	if(k1==0) COL1[count]=new Color(80,0,0);
	if(k1==1) COL1[count]=new Color(0,0,80);
	if(k1==0) COL2[count]=new Color(255,150,90);
	if(k1==1) COL2[count]=new Color(90,150,255);
	process(A,k0,k1);
    }

    public void process(BigRational[][] A,int k0,int k1) {
	double[][] a=new double[2][2];
	for(int i=0;i<2;++i) {
	    for(int j=0;j<2;++j) {
		a[i][j]=A[i][j].toDouble();
	    }
	}

	if(k1==0) {
	    a[0][0]=1-a[0][0];
	    a[0][1]=1-a[0][1];
	}


	double lx=X+a[0][0]*W;
	double rx=X+a[0][1]*W;
	double ly=Y+a[1][0]*H;
	double ry=Y+a[1][1]*H;



	P[count]=new Path2D.Double();
	P[count].moveTo(lx,ly);
	P[count].lineTo(rx,ly);
	P[count].lineTo(rx,ry);
	P[count].lineTo(lx,ry);
	P[count].closePath();
	accept(k0,k1);
	++count;
    }

}

