import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.math.*;



public class SpecialFunctions {



    /**Here is the combo potential*/

    public static double G(EnergyCombo E,double x) {
	double[][] K=new double[3][2];
	for(int i=0;i<3;++i) {
	    for(int j=0;j<2;++j) {
		K[i][j]=E.E[i][j].getVal();
	    }
	}
	return G(K,x);
    }


    public static double dG(EnergyCombo E,double x) {
	double[][] K=new double[3][2];
	for(int i=0;i<3;++i) {
	    for(int j=0;j<2;++j) {
		K[i][j]=E.E[i][j].getVal();
	    }
	}
	return dG(K,x);
    }


    public static double G(double[][] K,double x) {
	double tot=0;
	for(int i=0;i<3;++i) tot=tot+K[i][0]*G(K[i][1],x);
	return tot;
    }

    /**Here is the combo derivative*/
    public static double dG(double[][] K,double x) {
	double tot=0;
	for(int i=0;i<3;++i) tot=tot+K[i][0]*dG(K[i][1],x);
	return tot;
    }

    /**Here is the Tumanov potential - the main
       potential from the paper.*/

    public static double G(double k,double x) {
	if(k<.000001) return(1);
	return Math.pow(4-x*x,k);
    }

    /**Here is the derivative of the potential*/

    public static double dG(double k,double x) {
	if(k<.000001) return(0);
	return -2*k*x*Math.pow(4-x*x,k-1);
    }


    /**Here is the Riesz power law potential*/

    public static double R(double s,double x) {
	double a=1;
	if(s<0) a=-1;
	return a*Math.pow(x,-s);
    }

    /**Here is the derivative of the Riesz potential*/
    public static double dR(double s,double x) {
	double a=1;
	if(s<0) a=-1;
	return -s*a*Math.pow(x,-s-1);
    }


}



