import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.math.*;

public class BigRationalInterval {
    BigRational L,R;

    public BigRationalInterval() {}

    public BigRationalInterval(BigRational l,BigRational r) {
	this.L=BigRational.min(l,r);
	this.R=BigRational.max(l,r);
    }

    public BigRationalInterval scale(BigRational X) {
	BigRationalInterval Y=new BigRationalInterval();
	BigRational a=this.L.multiply(X);
	BigRational b=this.R.multiply(X);
	return new BigRationalInterval(a,b);
    }

    public BigRationalInterval multiply(BigRationalInterval X) {
	BigRational a0=this.L.multiply(X.L);
	BigRational a1=this.L.multiply(X.R);
	BigRational a2=this.R.multiply(X.L);
	BigRational a3=this.R.multiply(X.R);
	BigRational l=BigRational.min(a0,a1);
	l=BigRational.min(l,a2);
	l=BigRational.min(l,a3);
	BigRational r=BigRational.max(a0,a1);
	r=BigRational.max(r,a2);
	r=BigRational.max(r,a3);
	return new BigRationalInterval(l,r);
    }

    public BigRationalInterval add(BigRationalInterval X) {
	BigRational a0=this.L.add(X.L);
	BigRational a1=this.L.add(X.R);
	BigRational a2=this.R.add(X.L);
	BigRational a3=this.R.add(X.R);
	BigRational l=BigRational.min(a0,a1);
	l=BigRational.min(l,a2);
	l=BigRational.min(l,a3);
	BigRational r=BigRational.max(a0,a1);
	r=BigRational.max(r,a2);
	r=BigRational.max(r,a3);
	return new BigRationalInterval(l,r);
    }

    public BigRationalInterval subtract(BigRationalInterval X) {
	BigRational a0=this.L.subtract(X.L);
	BigRational a1=this.L.subtract(X.R);
	BigRational a2=this.R.subtract(X.L);
	BigRational a3=this.R.subtract(X.R);
	BigRational l=BigRational.min(a0,a1);
	l=BigRational.min(l,a2);
	l=BigRational.min(l,a3);
	BigRational r=BigRational.max(a0,a1);
	r=BigRational.max(r,a2);
	r=BigRational.max(r,a3);
	return new BigRationalInterval(l,r);
    }

    public static BigRationalInterval one() {
	BigRational L=new BigRational(1,1);
	BigRationalInterval Y=new BigRationalInterval(L,L);
	return Y;
    }

    public static BigRationalInterval zero() {
	BigRational L=new BigRational(0,1);
	BigRationalInterval Y=new BigRationalInterval(L,L);
	return Y;
    }

    public static BigRationalInterval powerBasic(BigRationalInterval S,int k) {
	BigRationalInterval R=one();
	for(int i=0;i<k;++i) R=R.multiply(S);
	return(R);
    }

    public void printN() {
	this.L.printN();
	System.out.println("   ");
	this.R.printN();
	System.out.println("");
    }
}


    

