import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;



public class CoeffCanvas extends ScaleCanvas implements KeyListener,MouseListener, MouseMotionListener {
    Manager M;  
    Lever SCALE; 
    Parameter[] P=new Parameter[6];
    ListenSquare INFO;

     public CoeffCanvas() {
	 addMouseListener(this);
	 addKeyListener(this);
	 addMouseMotionListener(this);	 
	 setScales(0,200,1);
	 for(int i=0;i<6;++i) P[i]=new Parameter(2,25+35*i,80,"1");
	 INFO=new ListenSquare(0,0,12,12);
     }


   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                         RenderingHints.VALUE_ANTIALIAS_ON);
      drawFrame1(g);
      drawLines(g);
      drawCoeff(g);     
      drawFrame2(g);    
   }

    public void drawFrame1(Graphics2D g) {
	g.setColor(new Color(0,0,0));
	g.fillRect(0,0,getWidth(),getHeight());
	g.setColor(Color.black);


    }

    public void drawFrame2(Graphics2D g) {
	g.setColor(new Color(0,0,90));
	g.fillRect(0,0,100,300);
	g.setColor(Color.white);
	g.drawRect(0,0,100,300);
	g.setColor(new Color(80,80,80));
	Color[] C=PresetData.colorScheme();
	for(int i=0;i<5;++i) P[i].render(g,C[i]);
	INFO.infoRender(g);
    }


    public void drawLines(Graphics2D g) {
	Path2D.Double gp=new Path2D.Double();
	gp.moveTo(100,0);
	gp.lineTo(1000,0);
	gp=transform(gp);
	g.setColor(Color.white);
	g.draw(gp);

	for(int i=0;i<180;++i) {
	  gp.reset();
	  gp.moveTo(100+2.5*i,-200);
	  gp.lineTo(100+2.5*i,400);
	  gp=transform(gp);
	  g.setColor(new Color(100,100,100,100));
	  g.draw(gp);
	}

	for(int i=0;i<19;++i) {
	  gp.reset();
	  gp.moveTo(100+25*i,-200);
	  gp.lineTo(100+25*i,400);
	  gp=transform(gp);
	  g.setColor(Color.blue);
	  if((i-2)%5==0) g.setColor(new Color(100,150,255));
	  if(i==18) g.setColor(Color.white);
	  g.draw(gp);
	}
    }


    public void drawCoeff(Graphics2D g) {
	double[] T=new double[5];
	for(int i=0;i<5;++i) {
	    T[i]=20000*P[i].getVal();
	}
	Color[] C=PresetData.colorScheme();
	Path2D.Double[] gp=new Path2D.Double[6]; 
     
	for(int i=0;i<5;++i) 
        gp[i]=new Path2D.Double();
	EnergyCombo[] d=M.C.ENG;
	for(int i=0;i<=5000;++i) {
	    double t=1.0*i/5000;
	    double s=-2*(1-t)+t*16;
	    double x=150+s*25;
	    double[] A=M.C.getTarget();
	    double[] e=new double[6];
	
	    e=ComputeCombo5.coeffList(d,A,s);
	    if(e==null) return;
	    for(int k=0;k<5;++k) {
	       if(i==0) gp[k].moveTo(x,T[k]*e[k]);
	       if(i!=0) gp[k].lineTo(x,T[k]*e[k]);
	    }
	}
	for(int i=0;i<5;++i) {
	    g.setColor(C[i]);
	    gp[i]=transform(gp[i]);
	    int test=M.C.ENG[i].Z2.on;
	    if(test==1) g.draw(gp[i]);
	}
    }





    public void mousePressed(MouseEvent e) { }


    public void mouseClicked(MouseEvent e) {  
       MouseData J=MouseData.process(e);
       for(int i=0;i<6;++i) P[i].process(e);
       if(J.X.x>100) {
         if(J.mode==3) scaleUp(J.X,1);
         if(J.mode==1) scaleUp(J.X,-1);
       }
       if(INFO.inside(J.X)==1) DocumentCoeff.main(M.D);
       M.repaint();
    }


     public void mouseReleased(MouseEvent e) {	 
     }

     public void mouseEntered(MouseEvent e) {
     }

     public void mouseExited(MouseEvent e) {
     }

    public void mouseMoved(MouseEvent e) { 
    }

    public void mouseDragged(MouseEvent e) {}

    public void keyTyped(KeyEvent e) { 
	for(int i=0;i<6;++i) P[i].processKey(false,e);
	repaint();
    }
    public void keyPressed(KeyEvent e) {}
    public void keyReleased(KeyEvent e) {}


}

