import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

public class Debug implements Runnable {
    boolean HALT;
    Manager M;

    public Debug() {
	HALT=true;
    }

    public Debug(Manager m) {
	this.M=m;
	HALT=true;
    }

    /**This file has the debugging routines*/

    public void run() {
	int k=M.C.DEBUG.mode;
	if(k==0) checkLog();
	if(k==1) arrays();
	if(k==2) poly1Operations();
	if(k==3) poly2Operations();
	if(k==4) checkSeriesCombo();
	if(k==5) twoVariableApprox();
    }

    public void checkLog() {
	for(int m=2;m<=4;++m) {
	    BigRational a=TaylorSeries.LOG(m,0);
	    BigRational b=TaylorSeries.LOG(m,1);
	    a.print();
	    System.out.print("<log("+m+")<");
	    b.println();
	    double aa=a.toDouble();
	    double bb=b.toDouble();
	    double c=Math.log(m);
	    double d1=bb-c;
	    double d2=c-aa;
	    System.out.println("positivity "+d1+" "+d2);
	    System.out.println("");
	}
    }

    public  void checkSeriesCombo() {
	HALT=false;
	long count=0;
	while(HALT==false) {
	   checkSeriesCombo1(count);
	   ++count;
	}
    }

    public  void checkSeriesCombo1(long count) {
	double t=randomVal();
	double s=2*Math.floor(.5*t+.5);
	double u=Math.abs(s-t);
	int s1=(int)(s);
	int s2=0;
	if(s<t) s2=1;
	long[] Y=randomCombo100();
	Poly1 P1=TaylorSeries.main(0,Y,s1,s2);
	Poly1 P2=TaylorSeries.main(1,Y,s1,s2);
        double test1=P1.evaluate(u);
	double test2=P2.evaluate(u);
	double test3=evaluateCombo(Y,t);
	double test31=test3-test1;
	double test23=test2-test3;
	System.out.println(count+" good "+s1+" "+s2);
	if(test31<0) throw new ProofException("bad");
	if(test23<0) throw new ProofException("bad");
	if(test31>.00001)  throw new ProofException("big");
	if(test23>.00001)  throw new ProofException("big");
    }


    public  double evaluateCombo(long[] Y,double t) {
	double[] a={Math.pow(2.0,-t/2),Math.pow(3.0,-t/2),Math.pow(4.0,-t/2)};
	double[] b={a[0],a[1],a[2],t*a[0],t*a[1],t*a[2]};
	double tot=0;
	for(int i=0;i<6;++i) tot=tot+b[i]*Y[i];
	return tot;
    }



    public void arrays() {
	long[][] m1=GenerateCoeffs.getArray(M.C.ENG);
	long[][] m2=GenerateCoeffs.spread(M.C.ENG);
	long[][] m3=GenerateCoeffs.derive1(m2);
	long[][] dm2=GenerateCoeffs.derive2(m2);
	long[][] dm3=GenerateCoeffs.derive2(m3);

	System.out.println("---------------------");
	System.out.println("the array");
	for(int i=0;i<5;++i) {
	    for(int j=0;j<5;++j) {
		System.out.print(m1[i][j]+" ");
	    }
	    System.out.println("");
	}
	System.out.println("---------------------");
	System.out.println("");
	System.out.println("the spread");
	for(int i=0;i<15;++i) {
	    for(int j=0;j<5;++j) {
		System.out.print(m2[i][j]+" ");
	    }
	    System.out.println("");
	}

	System.out.println("---------------------");
	System.out.println("the derived spread");
	for(int i=0;i<15;++i) {
	    for(int j=0;j<5;++j) {
		System.out.print(m3[i][j]+" ");
	    }
	    System.out.println("");
	}
	System.out.println("---------------------");
    }


    public void poly1Operations() {
	System.out.println("two random polynomials");
	System.out.println("P");
	Poly1 P=randomPoly1();
	P.print();
	Poly1 Q=randomPoly1();
	System.out.println("Q");
	Q.print();

	System.out.println("multiplication by x");
	System.out.println("xQ");
	Q.shiftUp();
	Q.print();

	Poly1 R=Q.add(P);
	BigRational x=randomBigRational();
	BigRational p=P.evaluate(x);
	BigRational q=Q.evaluate(x);
	BigRational r=R.evaluate(x);
	BigRational test=r.subtract(p.add(q));
	System.out.println("add test: ");test.println();

	R=P.subtract(Q); 
	r=R.evaluate(x);
        test=r.subtract(p.subtract(q));
	System.out.println("subtract test: ");test.println();

	BigRational scale=randomBigRational();
	R=P.scale(scale);
	r=R.evaluate(x);
	test=r.subtract(p.multiply(scale));
	System.out.println("scale test: ");test.println();

	P.LEFT=new BigRational(0,1);
	P.RIGHT=new BigRational(1,1);
	Poly1 P1=P.sub1();
	BigRational x1=x.multiply(new BigRational(2,1));
	BigRational y1=P1.evaluate(x1);
	BigRational y=P.evaluate(x);
	System.out.print("sub1 test ");
	test=y.subtract(y1);
	test.println();

	Poly1 P2=P.sub2(true);
	BigRational x2=x1.subtract(new BigRational(1,1));
	BigRational y2=P2.evaluate(x2);	
        test=y.subtract(y2);
	System.out.print("sub2A test ");
	test.println();

	P2=P.sub2(false);
	BigRational ONE=new BigRational(1,1);
	x2=ONE.subtract(x2);
	y2=P2.evaluate(x2);	
        test=y.subtract(y2);
	System.out.print("sub2B test ");
	test.println();


    }




    public void poly2Operations() {
	BigRational ONE=new BigRational(1,1);
	BigRational TWO=new BigRational(2,1);
	Poly2 P=randomPoly2();
	Poly2 Q00=P.subdivide0(0);
	Poly2 Q01=P.subdivide0(1);
	Poly2 Q10=P.subdivide1(0);
	Poly2 Q11=P.subdivide1(1);

	BigRational x=randomBigRational();
	BigRational y=randomBigRational();
	BigRational x1=x.multiply(TWO);
	BigRational y1=y.multiply(TWO);
	BigRational x2=x1.subtract(ONE);
	BigRational y2=y1.subtract(ONE);

	BigRational z=P.evaluate(x,y);
	Poly2 RP=P.reflect();
	BigRational rx=ONE.subtract(x);
	System.out.println("reflect test");
	BigRational rz=RP.evaluate(rx,y);
	BigRational test=rz.subtract(z);
	test.println();

	System.out.println("subdivision tests");

	BigRational z00=Q00.evaluate(x1,y);
	test=z.subtract(z00);
	test.println();

 	BigRational z01=Q01.evaluate(x,y1);
        test=z.subtract(z01);
	test.println();

	BigRational z10=Q10.evaluate(x2,y);
        test=z.subtract(z10);
	test.println();

	BigRational z11=Q11.evaluate(x,y2);
        test=z.subtract(z10);
	test.println();

	System.out.println("scale test");
	BigRational s1=randomBigRational();
	BigRational s2=randomBigRational();
	if(s1.isNegative()==true) s1=s1.negate();
	if(s1.isZero()==true) s1=new BigRational(1,1);
	if(s2.isNegative()==true) s2=s2.negate();
	if(s2.isZero()==true) s2=new BigRational(1,1);
	Poly2 SP=P.scale(s1,s2);
	x1=x.divide(s1);
	y1=y.divide(s2);
	BigRational sz=SP.evaluate(x1,y1);
	test=sz.subtract(z);
	test.println();


    }





    /**This checks the 2-variable under and over approximations
       from the paper.*/


    public void twoVariableApprox() {
  	double t=M.C.getExponent();
	System.out.println("-------------");
	System.out.println("exponent "+t);
	double s=2*Math.floor(.5*t+.5);
	double u=Math.abs(s-t);
	int s1=(int)(s);
	int s2=0;
	if(s<t) s2=1;
	System.out.println("interval specifiers "+s1+" "+s2);
	System.out.println("local coordinate "+u);

	Poly2 P0=TaylorSeries2.psi(s1,s2,0,M.C.ENG);
	Poly2 P1=TaylorSeries2.psi(s1,s2,1,M.C.ENG);
	Path2D.Double gp1=new Path2D.Double();
	System.out.println("check for roots corresponding to sq2 and sq3");
	double min=0;
	for(int i=0;i<510;++i) {
	    double v=1.0*i/1000;
	    double y1=P0.evaluate(u,v);
	    double y2=P1.evaluate(u,v);
	    double x=2*Math.sqrt(1-v);
	    if(Math.abs(x*x-2)<.001)
	    System.out.println(x+" "+x*x+":  "+y1+" "+y2);
	    if(Math.abs(x*x-3)<.001)
	    System.out.println(x+" "+x*x+":  "+y1+" "+y2);
	    if(min<Math.abs(y1)) min=Math.abs(y1);
	    if(i==0) gp1.moveTo(x,y1);
	    if(i!=0) gp1.lineTo(x,y1);
	}
	try{M.P.DEBUG1=new Path2D.Double(gp1); 
            M.P.DEBUG_RANGE1=min;}
	catch(Exception e) {
	    System.out.println("open up the approx window");
	}

	min=0;
	Poly2 Q0=TaylorSeries2.psiDiff(s1,s2,0,M.C.ENG);

	Path2D.Double gp2=new Path2D.Double();
	for(int i=0;i<510;++i) {
	    double v=1.0*i/1000;
	    double y=Q0.evaluate(u,v);
	    double x=2*Math.sqrt(1-v);
	    if(min<Math.abs(y)) min=Math.abs(y);
	    if(i==0) gp2.moveTo(x,y);
	    if(i!=0) gp2.lineTo(x,y);
	}
	try{M.P.DEBUG2=new Path2D.Double(gp2); 
            M.P.DEBUG_RANGE2=min;}
	catch(Exception e) {
	    System.out.println("again, open up the approx window");
	}
	System.out.println("-------------");
	M.repaint();
    }


    /**Makes a random cubic*/

    public Poly1 randomPoly1() {
	Poly1 P=new Poly1();
	int k=(int)(1+Math.random()*10);
	P.degree=k;
	for(int i=0;i<k;++i) {
	    P.C[i]=randomBigRational();
	}
	return P;
    }

    public Poly2 randomPoly2() {
	Poly2 P=new Poly2();
	int k=(int)(1+Math.random()*10);
	int count=0;
	for(int i=0;i<k;++i) {
	    for(int j=0;j<k;++j) {
		P.m[count]=new Mono2(randomBigRational(),i,j);
		++count;
	    }
	}
	P.count=count;
	return P;
    }



    public  BigRational randomBigRational() {
	return new BigRational(random100(),random100()+101);
    }

    public  long[] randomCombo100() {
	long[] Y=new long[6];
	for(int i=0;i<6;++i) Y[i]=random100();
	return Y;
    }


    public  long random100() {
	long y=(long)(200*Math.random()-100);
	return y;
    }


    public  int random() {
	int y=(int)(200*Math.random()-100);
	return y;
    }



    /**random value between -2 and 16*/
    public  double randomVal() {
	double t=Math.random();
	return t*(-2)+(1-t)*16;
    }



}
