import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

/**Documentation file*/


public class DocumentControl {

    public static void sendTo(DocumentCanvas D,String S) {
	try{
          D.setExplain(S);
          D.repaint();   
	  D.Y0=0;
          D.Y1=0;
	}
	catch(Exception e) {}
    }

    public static void compete(DocumentCanvas D) {
	String S="TBP versus FP competition";

	S=S+"\n\nConjecturally, all of these energy combos are minimized either at the TBP or at some FP (pyramid with square base). Whenever our program updates, it numerically finds the minimimum of the energy combo on the set of FPs and compares it with the minimum on the TBP.\n\nThe button turns blue is the TBP wins\nThe button turns red if some FP wins\n\nThe button is magenta if they are equal.  This happens, for instance, with G0, the constant function.";

	S=S+"\n\nThese buttons are extremely important for experimental purposes, because we want to decide to look for good energy combos. This how we found the complicated energy combo G10 + 28 G5 + 102 G2 from the paper.";

	S=S+"\n\nYou can see the button turn blue by choosing the energy combo G7, for instance.";

	sendTo(D,S);
    }


    public static void preset(DocumentCanvas D) {
	String S="Energy combo presets";

	S=S+"\n\nOne way to change the energy combos is to enter numders using the keyboard into the colored fields at the left.  However, you can also push these preset buttons to get some interesting ones.\n\n-- The first 3 presets are Cases 1,2,3 from the paper.\n\n--The 4th preset is a combo that, if pursued, would handle all energy exponents in the range [0,11].  We found this one first, but then Case 3 in the paper supercedes it.\n\n--The 5th preset corresponds to the additional lemma mentioned in the discussion section of the paper intro.";

	S=S+"\n\nYou should open up the coeffs and approx window to best appreciate all these presets.";

	sendTo(D,S);
    }

    public static void combo(DocumentCanvas D) {
	String S="Energy combo fields";

	S=S+"\n\nHere you should look at the 5 rows of rectangles. The first row is green, the second is yellow, etc. There are 7 same-colored rectangles in each row.  The first 6 let you enter numbers\n\nA,a,B,b,C,c.\n\nYou enter the numbers by clicking on the rectangle and then typing with the keyboard.  For the long rectangles you can get negative numbers by clicking the (-) button.  Clicking the (-) button again cancels this.";

	S=S+"\n\nThe numbers A,a,B,b,C,c specify the energy combo\n\n A Ga + B Gc + D Gc.\n\nFor instance, the numbers 1,5,0,1,0,1 specify G5 and the numbers 1,10,28,5,102,2 specify 1 G10 + 28 G5 + 102 G2.  All the combos relevant to the paper can be obtained by pressing the preset combos but you might want to experiment around.";

	S=S+"\n\nThe 7th button in the row toggles whether or not the corresponding coefficient corresponding to the energy combo is plotted in the coefficient canvas or subjected to the positivity test.  We have this option because you might want to view the functions one at a time. This was useful for debugging purposes.   The way that the buttons correspond to the functions for the positivity test is a bit nonstandard.  The top row, row 0, is never tested.  This is the coefficient in front of the constant function G0, and we need not test its sign.  The button on the top row toggles the test of the extra function \u0393'(2)-F'(2).  Then the remaining buttons control the function corresponding to the row of the button. The button on row 1 controls function 1, the button on row 2 controls function 2, and so on.";

	S=S+"\n\nOnce you specify the 5 energy combos - meaning the green one, the yellow one, etc., the computer solves the approximation problem with respect to them.  That is it finds the combo\n\na1 F1 + ... + a5 F5\n\nwhich:\n\n has the same value as a given Riesz potential at the points \u221A2,\u221A3,\u221A4, and\nhse the same derivative as the given Riesz potential at the points \u221A2,\u221A3.\n\nThat is why we have 5 energy combos.  This is explained more carefully in Chapter 8, Section 1 of the paper.  To see the plot of these coefficients as a function of the exponent, open up the coefficient canvas and read the documentation.";

	S=S+"\n\nThe 8th bottons in the row have to do with the competition between the TBP and the FP. Click on the question box beside these boxes to learn more.";

	sendTo(D,S);
    }


    public static void test(DocumentCanvas D) {
	String S="test choice";

	S=S+"\n\nThere are 3 options for what the GO button does:";

	S=S+"\n\n--positivity: This option tests the functions plotted in the Coefficient canvas for positive dominance on the specified domain of exponents. These are the coefficients treated in Chapter 8 of the paper.  You specify the domain using the red arrow keys at the bottom of this window.  It is best to use the preset combo options because these automatically set the domain limits to what they are in the paper.  The results of the test are printed out at the command line.  You can read more about the test options by clicking on the question box for the 'mode' control panel.";

	S=S+"\n\n--simple root: This option does the 2-variable parallel positive dominance option to prove the lemma about simple roots from Chapter 8 of the paper.";

	S=S+"\n\n--debug: This option brings up the debugger.  You can read about what the debugger does by clicking the question box on the 'debug' control panel.";

	sendTo(D,S);
    }


    public static void popups(DocumentCanvas D) {
	String S="popups";

	S=S+"\n\nThis control panel controls the popup windows.  You can get a much better appreciation for this program by opening up the popup windows.  You do this by clicking on the buttons. Once a popup is open, you can kill it if you don't want to look at it anymore.  Then, you can bring it back again. Practice opening up the popup windows and killing them and opening them up and killing them, etc.";

	sendTo(D,S);
    }


    public static void debug(DocumentCanvas D) {
	String S="debugger";

	S=S+"\n\nThe debugger has 6 options:";
	S=S+"\n\n--log(m): This checks numerically that our rational approximatons to log(2), log(3), log(4) are indeed over approximations and under approximations. It also prints out these approximations.";

	S=S+"\n\n--arrays: The whole point of our program is to study the functions a1,a2,a3,a4,a5,\u03B4 (from Section 8.2).  These are functions of the exponent s and the choice of 5 energy combos. The solution is always given in terms of a rational matrix M':\n\n(a1,a2,a3,a4,a5,\u03B4)=(M').(2^(-s/2),3^(-s/2),4^(-s/2),s2^(-s/2),s3^(-s/2),s4^(-s/2)),\n\nSince we are only interested in the positivity of these functions and in other properties which do not change when we replace M' by an integer multiple M, the matrix obtained by clearing all denominators of M'. This debugging option displays M.  The ratio M/M' is given as the only nonzero entry of the first row.  Thus, if the energy combos areG0,G1,G2,G3,G5 then M/M'=144.  You can try this case and see. This option also shows the matrices which we use to construct the functions \u03A8 and d\u03A8/dt used in the lemmas from Chapter 8.";



	S=S+"\n\n--poly1 operations: This checks the basic operations on 1-variable polynomials: addition, subtraction, scaling, etc..";


	S=S+"\n\n--poly2 operations: This checks the basic operations on 2-variable polynomials..";



	S=S+"\n\n--power combo approx: This is the main debugging routine. We choose a random intever vector Y,  a random integer unit interval I, and a random point x in I. We then compute the polynomial under and over approximations to the power combo f based on (Y,I).  Call the approximations m and M.  We check that m<f<M and that M-m<10^{-4}.  This is essentially checking our implementation of the Taylor series for various power functions.";

	S=S+"\n\n--2-variable poly:  In Section 8.6 of the paper we describe how we produce the 2 variable approximations to the functions \u03A8 and d\u03A8/dt.  For each fixed parameter s, the approximations to \u03A8 should be functions whose zeros appear at the extrema of the function Z=(+/-)(1-\u0393/R).  Here \u0393 is the weghted average of the energy combos and R is the power law.  This plots the graphs of the polynomial approximations of \u03A8 in yellow in the approx window and you can see that it crosses the x-axis at the extrema of Z.  Likewise, this plots the polynomial approximations of  d\u03A8/dt in red and you can see that it crosses the x-axis at the extrema of the yellow curve.\n\nThere is a subtle point: The function d\u03A8/dt is an approximation to the derivative of \u03A8 with respect to the t variable, but t = 4-x^2.  The horizontal direction in our plots is the x variable and not the t variable.  So, strictly speaking, the red curve is not supposed to be the derivative of the yellow curve.  Nonetheless, the red curve should cross the x-axis at the extrema of the red curve.\n\nAfter you run this option you can erase the red and yellow curves by changing the exponent on the control panel.";

	sendTo(D,S);
    }


    public static void mode1(DocumentCanvas D) {
	String S="test mode";

	S=S+"\n\nWhen you run the positivity tests, there are 4 options for the test";
	S=S+"\n\n--Version 1:  This does the one variable positive dominance algorithm as described in the paper.  For the relevant functions, the algorithm hardly needs to run.  In some case, the initial function is already positive dominant on [0,1].  In all other cases, the function is positive dominant on each of [0,1/2] and [1/2,1], and one checks this by pulling back via:\n\nThe orientation preserving affine map from [0,1] to [0,1/2]\nThe orientation reversing affine map from [0,1] to [1/2,1].";

	S=S+"\n\n--Version 2:  This does the same thing as version 1 except that, in case we need to divide [0,1] in half, the positive dominance on each half is checked by pulling back via orientation preserving maps in both cases. When Version 2 is incorporated into the positive dominance algorithm it has the beautiful property that the intervals are passed in the order they appear on the number line.   Thus, if the positive dominance algorithm fails, you can see exactly where it breaks down. You will see success on smaller and smaller intervals approaching the bad point. You can see this in action by selecting the second-to-last preset combo and trying it out. (This preset combo is related to the extra lemma mentioned in the discussion section of the intro of the paper.)  The only problem with Version 2 is that the algorithm does not halt in Case 1 of the paper.  This is the first preset combo option.  Try both versions and see the difference.";

	S=S+"\n\nprintN:  This prints a decimal approximation of the polynomials being tested.  If we test all A of the 5 coefficients on an interval of length B, then there will be AB polynomials created.";

	S=S+"\n\nprint:  This prints the exact polynomials.  This option is not very revealing because the rational coefficients are enormous.";

	sendTo(D,S);
    }
}


