import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;


public class EnergyCombo {
    Parameter[][] E=new Parameter[3][2];
    ListenSquare Z1;
    ListenSquare Z2;
    int Y;

    public EnergyCombo(int y,String S0) {
	this.Y=y;
	String[][] S={{"1",S0},{"0","1"},{"0","1"}};
        for(int i=0;i<3;++i) {
	    E[i][0]=new Parameter(90*i,Y,50,S[i][0]);
	    E[i][1]=new Parameter(90*i+55,Y,25,S[i][1]);
	}
	Z1=new ListenSquare(270,Y,20,20);Z1.on=1;
	Z2=new ListenSquare(275,Y+5,10,10);Z2.on=1;
    }

    public void render(Graphics2D g,Color C) {
     for(int i=0;i<3;++i) {
       for(int j=0;j<2;++j) {
	   E[i][j].render(g,C);
       }
     }
     Z1.render(g,C);
     if(Z2.on==1) Z2.render(g,Color.black);
    }


    public void process(MouseEvent e) {
	for(int i=0;i<3;++i) {
	    E[i][0].process(e);
	    E[i][1].process(e);
	}   
        MouseData J=MouseData.process(e);
	if(Z1.inside(J.X)==1) Z2.on=1-Z2.on;
    }

    public void processKey(KeyEvent e) {
	for(int i=0;i<3;++i) {
	    E[i][0].processKey(false,e);
	    E[i][1].processKey(true,e);
	}
    }


}

