import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.math.*;

/**Gets the coeffs for the positive dominance tests*/

public class GenerateCoeffs {

    /**This gets the specified choice of row in the array*/

    public static long[] getRow(EnergyCombo[] d,int choice) {
	long[][] m=getArray(d);
	return(m[choice]);
    }


    /**This just works for the TBP target*/

    public static long[][] getArray(EnergyCombo[] d) {
	double[] A={Math.sqrt(2),Math.sqrt(3),2};
	Matrix M=ComputeCombo5.getMatrix(d,A);
	double r=Matrix.det(M);
	M=Matrix.inverse(M);
	M=Matrix.scale(M,r);
	M=M.transpose();
	long[][] m=MathHelp.nearestLong(M,6);
	m[5]=derivativeAtTwo(d,m);
	long g=MathHelp.GCD(m);
	m=MathHelp.reduce(m);
	long test=MathHelp.nearestLong(r/g);
	m[5][5]=test;
	if(test<0) m=MathHelp.negate(m);
	return m;
    }


    public static long[] derivativeAtTwo(EnergyCombo[] d,long[][] m) {
	long[] Y={0,0,0,0,0,0};
	for(int a=0;a<5;++a) {
	    for(int b=0;b<3;++b) {
		if(d[a].E[b][1].S.equals(new String("1"))) {
		    int COEFF=d[a].E[b][0].getVal();
                    for(int j=0;j<5;++j) {
                       Y[j]=Y[j]-8*COEFF*m[1][j];
		    }
		}
	    }
	}
	return Y;
    }

    /**This converts the original array into an array of
       coefficients for the corresponding pure combination. 
       In other words, we start with something like
       c0 (energy combo 0) + c1 (energy combo 1) +...
       and we end with something like
       a0 G0 + a1 G1 + a2 G2...
    */

    public static long[][] spread(EnergyCombo[] d) {
	long[][][] e=new long[5][3][2];
	for(int i=0;i<5;++i) {
	    e[i]=MathHelp.nearestLong(d[i]);
	}
	long[][] m=getArray(d);
	long[][] n=new long[15][5];

	for(int i=0;i<5;++i) {
	    for(int j=0;j<3;++j) { 
               long cff=e[i][j][0];
	       int exp=(int)(e[i][j][1]);
	       for(int k=0;k<5;++k) {
		   n[exp][k]=n[exp][k]+cff*m[i][k];
	       }
	    }
	}
	return n;
    }




    /**Suppose that F is the pure (i.e. spread) combination.
       The logarithmetic derivative of H(r)=F(r) r^s
       is a rational function whose numerator is
       s F + r F'.   Here we compute r F'.  The
       general rule for the formula is that
       r G_k'(r) = 2k G_k(r) - 8k G_{k-1}(r)*/

    public static long[][] derive1(long[][] m) {
	long[][] n=new long[15][5];
	for(int i=1;i<15;++i) {
	    for(int j=0;j<5;++j) {
		n[i+0][j]=n[i+0][j]+2*i*m[i][j];
		n[i-1][j]=n[i-1][j]-8*i*m[i][j];
	    }
	}
	return n;
    }


    /**This function computes the derivative d/dt when
       we make the substitution t=4-r^2.*/

    public static long[][] derive2(long[][] m) {
	long[][] n=new long[15][5];
	for(int i=1;i<15;++i) {
	    for(int j=0;j<5;++j) {
		n[i-1][j]=n[i-1][j]+i*m[i][j];
	    }
	}
	return n;
    }


}



