import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;




public class PictureCanvas extends ScaleCanvas implements KeyListener,MouseListener, MouseMotionListener {
    Manager M;  
    ListenSquare BLOCK;
    Path2D.Double DEBUG1,DEBUG2,DEBUG3;
    double DEBUG_RANGE1,DEBUG_RANGE2;
    HSlider RANGE;
    Point JX;
    ListenSquare INFO;

     public PictureCanvas() {
	 addMouseListener(this);
	 addKeyListener(this);
	 addMouseMotionListener(this);	 
	 setScales(20,220,160);
	 BLOCK=new ListenSquare(0,0,400,40);
	 DEBUG1=null;
	 DEBUG2=null; 
         Color[] C1={new Color(50,100,255),Color.white,Color.white};
	 RANGE=new HSlider(0,0,340,20,200,C1,"plot range: from x to 2");
	 INFO=new ListenSquare(387,0,12,12);
     }


   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                         RenderingHints.VALUE_ANTIALIAS_ON);
      drawFrame(g); 
      drawPlot(g); 
      drawDebug1(g);
      drawDebug2(g);
      drawControls(g);
   }

    public void drawFrame(Graphics2D g) {
	g.setColor(new Color(0,0,50));
	g.fillRect(0,0,getWidth(),getHeight());
	Path2D.Double gp=new Path2D.Double();
	gp.moveTo(-10,0);
	gp.lineTo(10,0);
	gp.moveTo(0,-10);
	gp.lineTo(0,10);
	gp=transform(gp);
	g.setColor(new Color(50,100,255));
	g.draw(gp);
	gp.reset();
	gp.moveTo(Math.sqrt(2),-10);
	gp.lineTo(Math.sqrt(2),10);
	gp.moveTo(Math.sqrt(3),-10);
	gp.lineTo(Math.sqrt(3),10);
	gp.moveTo(2,-10);
	gp.lineTo(2,10);
	gp=transform(gp);
	g.setColor(new Color(0,100,100));	
        g.draw(gp);	
    }


    public void drawPlot(Graphics2D g) {

	EnergyCombo[] d=M.C.ENG;
	double ex=M.C.getExponent();

	double[] A=M.C.getTarget();
	double[] e=new double[5];
	e=ComputeCombo5.coeffList(d,A,ex);
	double y2=0;

	Path2D.Double gp=new Path2D.Double();
	double y0=0;

	int rv=(int)(2*RANGE.getValue()*1000);

	for(int i=rv;i<=2000;++i) {
	    double x=1.0*i/1000;
	    double y1=SpecialFunctions.R(ex,x);
	    y2=ComputeCombo5.cone(e,d,x);
	    double sign=1;
	    if(ex<0) sign=-1;
	    double y=sign*(1-y2/y1);
	    if(y0<y) y0=y;
	    if(i==rv) gp.moveTo(x,y);
	    if(i>rv) gp.lineTo(x,y);
	}
	AffineTransform SC=AffineTransform.getScaleInstance(1,1/y0);
	gp.transform(SC);
	gp=transform(gp);
	g.setColor(Color.white);
	g.draw(gp);
    }


    public void drawDebug1(Graphics2D g) {
	if(DEBUG1==null) return;	
	double s=1/DEBUG_RANGE1;
	Path2D.Double gp=new Path2D.Double(DEBUG1);
	AffineTransform SC=AffineTransform.getScaleInstance(1,s);
	gp.transform(SC);
        gp=transform(gp);
	g.setColor(Color.yellow);
	g.draw(gp);
    }

    public void drawDebug2(Graphics2D g) {
	if(DEBUG2==null) return;	
	double s=1/DEBUG_RANGE2;
	Path2D.Double gp=new Path2D.Double(DEBUG2);
	AffineTransform SC=AffineTransform.getScaleInstance(1,s);
	gp.transform(SC);
        gp=transform(gp);
	g.setColor(new Color(255,0,80));
	g.draw(gp);
    }

    public void drawControls(Graphics2D g) {
        BLOCK.render(g,new Color(0,0,150));  
        RANGE.render(g);
	Double D=new Double(2*RANGE.getValue());
	g.setColor(Color.white);
	g.drawString("x="+D.toString(),200,18);
	INFO.infoRender(g);

    }


    public void mousePressed(MouseEvent e) { }


    public void mouseClicked(MouseEvent e) {  
       MouseData J=MouseData.process(e);
       doMouseClick(J.mode,J.X);
    }

    public void doMouseClick(int mode,Point X) {
       if(BLOCK.inside(X)!=1) {
         if(mode==3) scaleUp(X,1);
         if(mode==1) scaleUp(X,-1);
       }
       if(INFO.inside(X)==1) DocumentApprox.main(M.D);
       M.repaint();
    }

     public void mouseReleased(MouseEvent e) {	 
     }

     public void mouseEntered(MouseEvent e) {
	 requestFocus();
     }

     public void mouseExited(MouseEvent e) {
     }

    public void mouseMoved(MouseEvent e) {  
        MouseData J=MouseData.process(e);
	JX=J.X;
    }

    public void mouseDragged(MouseEvent e) {  
       MouseData J=MouseData.process(e);
       RANGE.modify(J.X);
       repaint();
    }


    public void keyTyped(KeyEvent e) { 
	char ch=e.getKeyChar();
	int mode=0;
	if(ch=='z') mode=1;
	if(ch=='x') mode=2;
	if(ch=='c') mode=3;
	if(ch=='b') mode=1;
	if(ch=='n') mode=2;
	if(ch=='m') mode=3;
	doMouseClick(mode,JX);
	repaint();
    }
    public void keyPressed(KeyEvent e) {}
    public void keyReleased(KeyEvent e) {}


}

