import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.math.*;

/**This is the class for a polynomial in 2 variablrs.
   The maximum individual degree is set to 16.*/

public class Poly2 {
    static int LIM=16;
    Mono2[] m=new Mono2[400];
    int[] age=new int[2];
    int count;
    boolean special;
    BigRational LEFTX,RIGHTX,LEFTY,RIGHTY;
    int c0,c1;

    public Poly2() {
	this.LEFTX=new BigRational(0,1);
	this.RIGHTX=new BigRational(1,1);
	this.LEFTY=new BigRational(0,1);
	this.RIGHTY=new BigRational(1,1);
    }

    /**Copies a polynomial*/
    public Poly2(Poly2 P) {
	this.count=P.count;
	for(int i=0;i<this.count;++i) this.m[i]=new Mono2(P.m[i]);
	for(int i=0;i<2;++i) age[i]=P.age[i];
	this.LEFTX=new BigRational(P.LEFTX);
	this.RIGHTX=new BigRational(P.RIGHTX);
	this.LEFTY=new BigRational(P.LEFTY);
	this.RIGHTY=new BigRational(P.RIGHTY);
	this.c0=P.c0;
	this.c1=P.c1;
    }


    /**Makes the polynomial P[0] + P[1] y + P[2] y^2 ...*/
    public Poly2(Poly1[] P) {
	int count=0;
	for(int i=0;i<P.length;++i) {
	    for(int j=0;j<P[i].degree;++j) {
		int[] e={j,i};
		this.m[count]=new Mono2(P[i].C[j],e);
		++count;
	    }
	}
	this.count=count;
	this.LEFTX=new BigRational(0,1);
	this.RIGHTX=new BigRational(1,1);
	this.LEFTY=new BigRational(0,1);
	this.RIGHTY=new BigRational(1,1);
    }


    /**HERE ARE THE SCALING OPERATIONS*/

    /**NEW(x1,x2)=OLD(x1/2,x2) 
       only the first coordinate is changed.
       Feeds into the subdivision routines,
       which are checked by the debugger.*/

    public Poly2 dilate() {
	BigRational TWO=new BigRational(2,1);
	return dilate(TWO);
    }

    /**NEW(T0 x1,x2)=OLD(x1,x2).  This feeds into the
       subdivision routines, which are checked by the
       debugger.*/

    public Poly2 dilate(BigRational T0) {
	Poly2 P=new Poly2(this);
	for(int i=0;i<count;++i) {
	    int e=m[i].e[0];
	    BigRational T=BigRational.power(T0,e);
	    P.m[i].c=P.m[i].c.divide(T);
	}
	P.c0=this.c0;
	P.c1=this.c1;
	return(P);
    }

    /** NEW(x/SCALE0,y/SCALE0)=OLD(x,y).
        checked with the debugger*/

    public Poly2 scale(BigRational SCALE0,BigRational SCALE1) {
	BigRational S0=SCALE0.invert();
	BigRational S1=SCALE1.invert();
	Poly2 P=new Poly2(this);
	P=P.dilate(S0);
	P=P.rotate(1);
	P=P.dilate(S1);
	P=P.rotate(1);
	P.c0=this.c0;
	P.c1=this.c1;
	return P;
    }



    /**HERE IS THE REFLECT ROUTINE*/


    /**NEW(x1,x2)=OLD(1-x1,x2).  Checked with the debugger*/
    public Poly2 reflect() {
	BigRational[][] B=setToZero();
	for(int i=0;i<this.count;++i) {
	    BigRational[] t=pascalTriangleSigned(m[i].e[0]);
            int[] e=m[i].e;
	    for(int j=0;j<t.length;++j) {
		BigRational A=m[i].c.multiply(t[j]);
	        B[j][e[1]]= B[j][e[1]].add(A);
	    }
	}
	Poly2 P=coeffToPoly(B);
	for(int i=0;i<2;++i) P.age[i]=this.age[i];
	P.c0=this.c0;
	P.c1=this.c1;
	return(P);
    }

    /**This feeds into the reflect routine.*/
    public Poly2 coeffToPoly(BigRational[][] B) {
	Poly2 P=new Poly2();
	int c=0;
	for(int i0=0;i0<LIM;++i0) {
	for(int i1=0;i1<LIM;++i1) {
	    int[] I={i0,i1};
	    if(B[i0][i1].isZero()==false) {
		P.m[c]=new Mono2(B[i0][i1],I);
		++c;
	    }
	}}
	P.count=c;
	return(P);
    }

    /**These are the coefficients of (1-x)^k*/

    public static BigRational[] pascalTriangleSigned(int k) {
	BigRational[] P=new BigRational[k+1];
	for(int i=0;i<=k;++i) {
	    P[i]=BigRational.choose(k,i);
	    if(i%2==1) P[i]=P[i].negate();
	}
	return P;
    }


    /**Creates an array of 0s.  This feeds into the
       reflect operation*/

    public BigRational[][] setToZero() {
	BigRational[][] B=new BigRational[LIM][LIM];
	for(int i0=0;i0<LIM;++i0) {
	for(int i1=0;i1<LIM;++i1) {
	    B[i0][i1]=new BigRational(0,1);
	}}
	return(B);
    }




    /**HERE IS THE ROTATE ROUTINE*/

    /**When k=0 NEW=OLD.  
       When k=1 NEW(x,y)=OLD(y,x).
       These are the only values which come up*/

    public Poly2 rotate(int k) {
	Poly2 P=new Poly2(this);
	for(int i=0;i<count;++i) {
	    P.m[i]=m[i].rotate(k);
	}
	return(P);
    }



    /**The dilate, reflect, rotate routines
       are the building blocks for the subdivisions*/

    /**subdivision operations*/

    public Poly2 subdivide(int choice) {
	int k=youngestIndex();
	return(subdivide(choice,k));
    }


    public Poly2 subdivide(int choice,int k) {
	if(choice==0) return(subdivide0(k));
	return(subdivide1(k));
    }


    /**Checked with the debugger*/

    public Poly2 subdivide0(int k) {
	Poly2 P=new Poly2(this);
	P=P.rotate(-k);
	P=P.dilate();
	P=P.rotate(k);
	++P.age[k];


	if(k==0) {
          P.LEFTX=new BigRational(LEFTX);
          P.RIGHTX=RIGHTX.average(LEFTX);
          P.LEFTY=new BigRational(LEFTY);
          P.RIGHTY=new BigRational(RIGHTY);
	}

	if(k==1) {
          P.LEFTY=new BigRational(LEFTY);
          P.RIGHTY=RIGHTY.average(LEFTY);
          P.LEFTX=new BigRational(LEFTX);
          P.RIGHTX=new BigRational(RIGHTX);

	}

	return(P);
    }

    /**Checked with the debugger*/

    public Poly2 subdivide1(int k) {
	Poly2 P=new Poly2(this);
	P=P.rotate(-k);	
	P=P.reflect();	
	P=P.dilate();
	P=P.reflect();	
	P=P.rotate(k);	
	++P.age[k];

	if(k==0) {
          P.RIGHTX=new BigRational(RIGHTX);
          P.LEFTX=LEFTX.average(RIGHTX); 
           P.LEFTY=new BigRational(LEFTY);
          P.RIGHTY=new BigRational(RIGHTY);
	}

	if(k==1) {
          P.RIGHTY=new BigRational(RIGHTY);
          P.LEFTY=LEFTY.average(RIGHTY); 
          P.LEFTX=new BigRational(LEFTX);
          P.RIGHTX=new BigRational(RIGHTX);
	}
	return(P);
    }



    public int youngestIndex() {
	if(age[0]<=age[1]) return 0;
	return 1;
    }



    /**Negative Dominance*/
    public boolean isNegativeDominant() {
	Poly2 P=this.negate();
	return P.isPositiveDominant();
    }

    public Poly2 negate() {
	Poly2 P=new Poly2(this);
	for(int i=0;i<count;++i) {
	    P.m[i]=m[i].negate();
	}
	return(P);
    }

    /**Positive Dominance*/

    public boolean isPositiveDominant() {
	BigRational SUM=new BigRational(0,1);
	for(int i0=0;i0<LIM;++i0) {
	for(int i1=0;i1<LIM;++i1) {
	    int[] I={i0,i1};
	    SUM=new BigRational(0,1);
	    for(int j=0;j<count;++j) {
		boolean test=isDominated(m[j].e,I);
		if(test==true) {
		    SUM=SUM.add(m[j].c);
		}
	    }
            if(SUM.isPositive()==false) {
		return false;
	    }

	}}
	return(true);
    }
    public static boolean isDominated(int[] e,int[] I) {
	for(int i=0;i<2;++i) if(e[i]>I[i]) return(false);
	return(true);
    }


    public Poly2 diff() {
	Poly2 P=new Poly2();
	int count2=0;
	for(int i=0;i<count;++i) {
	    if(m[i].e[1]>0) {
		P.m[count2]=new Mono2();
		P.m[count2].c=m[i].c.multiply(new BigRational(m[i].e[1],1));
		P.m[count2].e[0]=m[i].e[0];
		P.m[count2].e[1]=m[i].e[1]-1;
		++count2;
	    }
	}
	P.count=count2;
	return P;
    }


    /**evaluation: for debugging*/

    public double evaluate(double x0,double x1) {
	double[] x={x0,x1};
	return evaluate(x);
    }

    public double evaluate(double[] x) {
	double s=0;
	for(int i=0;i<count;++i) s=s+m[i].evaluate(x);
	return s;
    }

    public BigRational evaluate(BigRational x,BigRational y) {
	BigRational[] xy={x,y};
	return evaluate(xy);
    }

    public BigRational evaluate(BigRational[] x) {
	BigRational s=new BigRational(0,1);
	for(int i=0;i<count;++i) s=s.add(m[i].evaluate(x));
	return s;
    }

    /**printouts*/
    public void print(String NAME) {
	System.out.print(NAME+"={");
	for(int i=0;i<count;++i) {
	    m[i].print();
	    if(i<count-1) System.out.print(",");
	    if(i==count-1) System.out.print("};");
	}
	System.out.println("");
    }

    public void printN(int k) {
	for(int i=0;i<count;++i) {
	    if((m[i].e[0]<k)&&(m[i].e[1]<k)) m[i].printN();
	}
	System.out.println("");
    }

    public void printEndpoints() {
	System.out.print("[");
	LEFTX.print();
	System.out.print("  ");
	RIGHTX.print();
	System.out.println("]");
    }

}