import java.math.*;

/**This class tests things about the power law potential.
   It is not used in the proofs for the paper*/

public class PowerLaw {


    public static double minFP(double e) {
	double a0=0;
	double a1=1;
	double b0=0;
	double b1=1;

	for(int i=0;i<100;++i) {
	    double t0=energyFP(e,a0);
	    double t1=energyFP(e,a1);
	    b1=.5*(a0+a1);
	    if(t0<=t1) b0=a0;
	    if(t0>=t1) b0=a1;
	    a0=b0;
	    a1=b1;
	}
	return energyFP(e,a0);
    }

    public static double interaction(double e,Vector V1,Vector V2) {
	double d=Vector.distSquared(V1,V2);
	d=Math.pow(d,-e/2);
	return(d);
    }

    public static double energy(double e,Vector[] V) {
	double total=0;
	for(int i=0;i<5;++i) {
	    for(int j=i+1;j<5;++j) {
                double term=interaction(e,V[i],V[j]);
		total=total+term;
	    }
	}
	return(total);
    }

    public static double energyFP(double e,double s) {
	double total=0;
	Vector[] V=TestNumerical.FP(s);
	return energy(e,V);
    }





}



