import java.math.*;

public class TestNumerical {

    public static int[] main(Manager M) {
	int[] list=new int[5];
	for(int i=0;i<5;++i) {
	   double x=energyTBP(M.C.ENG[i]);
	   double y=minFP(M.C.ENG[i]);
	   if(x<y) list[i]=0;
	   if(x>y) list[i]=1;
	   if(x==y) list[i]=2;
	}
	return list;
    }


    public static Vector[] TBP() {
	Vector[] V=new Vector[5];
	V[0]=new Vector(1,0,0);
	V[1]=new Vector(-1.0/2,-Math.sqrt(3)/2,0);
	V[2]=new Vector(0,0,-1);
	V[3]=new Vector(-1.0/2,+Math.sqrt(3)/2,0);
	V[4]=new Vector(0,0,1);
	return V;
    }

    public static Vector[] FP(double t) {
	Vector[] V=new Vector[5];
	double s=Math.sqrt(1-t*t);
	V[0]=new Vector(+s,0,-t);
	V[1]=new Vector(-s,0,-t);
	V[2]=new Vector(0,+s,-t);
	V[3]=new Vector(0,-s,-t);
	V[4]=new Vector(0,0,1);
	return V;
    }


    public static double interaction(double e,Vector V1,Vector V2) {
	double d=2+2*Vector.dot(V1,V2);
	d=Math.pow(d,e);
	return(d);
    }


    public static double energy(double e,Vector[] V) {
	double total=0;
	for(int i=0;i<5;++i) {
	    for(int j=i+1;j<5;++j) {
                double term=interaction(e,V[i],V[j]);
		total=total+term;
	    }
	}
	return(total);
    }

    public static double energyTBP(EnergyCombo d) {
	double total=0;
	Vector[] V=TBP();
	for(int i=0;i<3;++i) {
	    double c0=d.E[i][0].getVal();
	    double c1=d.E[i][1].getVal();
            total=total+c0*energy(c1,V);
	}
	return total;
    }

    public static double energyFP(EnergyCombo d,double s) {
	double total=0;
	Vector[] V=FP(s);
	for(int i=0;i<3;++i) {
	    double c0=d.E[i][0].getVal();
	    double c1=d.E[i][1].getVal();
            total=total+c0*energy(c1,V);
	}
	return total;
    }


    public static double minFP(EnergyCombo d) {
	double a0=0;
	double a1=1;
	double b0=0;
	double b1=1;

	for(int i=0;i<100;++i) {
	    double t0=energyFP(d,a0);
	    double t1=energyFP(d,a1);
	    b1=.5*(a0+a1);
	    if(t0<=t1) b0=a0;
	    if(t0>=t1) b0=a1;
	    a0=b0;
	    a1=b1;
	}
	return energyFP(d,a0);
    }


}



