import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class ContourPlot implements Runnable {
    PictureCanvas P;

    public ContourPlot() {
    }
    public ContourPlot(PictureCanvas PP) {
	this.P =PP;
    }

    /**Main routine*/
    public void run() {
	double max=0;
	double min=100;
	int i=0;
	int j=0; 

	int[][] E={{1,10},{13,5},{68,2}};
	int[] b={80,100,120};

	int bg=convert(b);

	while(true) {
	    ++i;
            if(i==600) {
                i=0;++j;
	    }
	    if(j==600) {
		i=0;j=0;
	        P.repaint();
	    }

	    Complex z=P.unTransform(i,j);
	    boolean test=inSquare(z);
	    if(test==false) P.IMAGE.setRGB(i,j,bg); 
	    if(test==true) {
		double t=Energy.energyNormalized(E,z);
		if(max<t) max=t;
		if(min>t) {
                    min=t;
		}
		int t4=0;
		if(t<1) t4=255;
		if((t>=1)&&(t<1.01)) t4=100;
	        int[] c={0,0,t4};
	        int col=convert(c);
	        P.IMAGE.setRGB(i,j,col);
	    }
	}
    }

    public static boolean inSquare(Complex z) {
	if(z.x<21.0/32) return false;
	if(z.x>1) return false;
	if(z.y<21.0/32) return false;
	if(z.y>1) return false;
	return true;
    }


    public static int convert(int[] a) {
	int n=256*256*a[0]+256*a[1]+a[2];
	return(n);
    }


}


