import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

public class Energy {



    public static double energyNormalized(int[][] E,Complex z) {
	double d1=energySymm(E,z);
	double d2=energyTBP(E);
	return d1/d2;
    }

    public static double energySymm(int[][] E,Complex z) {
	Complex[] w=new Complex[4];
	w[0]=new Complex(+z.x,0);
	w[1]=new Complex(0,-z.y);
	w[2]=new Complex(-z.x,0);
	w[3]=new Complex(0,+z.y);
	return energy(E,w);
    }


    public static double energyTBP(int[][] E) {
	Complex z=new Complex(1,Math.sqrt(3)/3);
	return energySymm(E,z);
    }




    /**This is the fundamental routine*/

    public static double interaction(int e,Vector V1,Vector V2) {
	double d=2+2*Vector.dot(V1,V2);
	d=Math.pow(d,e);
	return(d);
    }

    /**This routine computes the total energy of 
       4 points in the plane, plus the point at
       infinity.  These 4 points are  mapped 
       stereographically to the unit sphere, and
       the vector (0,0,1) is included as the 
       image of infinity.  */

    public static double energy(int e,Complex[] z) {
	Vector[] V=new Vector[5];
	for(int i=0;i<4;++i) V[i]=Vector.inverseStereo(z[i]);
	V[4]=new Vector(0,0,1);

	double total=0;
	for(int i=0;i<5;++i) {
	    for(int j=i+1;j<5;++j) {
		total=total+interaction(e,V[i],V[j]);
	    }
	}
	return(total);
    }

    public static double energy(int[][] E,Complex[] z) {
	double tot=0;
	for(int i=0;i<3;++i) {
	    double abs=Math.abs(E[i][0]);
	    if(abs>.0000001) {
               tot=tot+E[i][0]*energy(E[i][1],z);
	    }
	}
	return tot;
    }


}


