import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;


public class PowerLaw {

    public static double energyNormalized(double e,Complex z) {
	double d1=energy(e,z);
	double d2=energyTBP(e);
	return d1/d2;
    }

    public static double energy(double e,Complex z) {
	Complex[] w=new Complex[4];
	w[0]=new Complex(+z.x,0);
	w[1]=new Complex(0,-z.y);
	w[2]=new Complex(-z.x,0);
	w[3]=new Complex(0,+z.y);
	return energy(e,w);
    }


    public static double energyTBP(double e) {
	Complex z=new Complex(1,Math.sqrt(3)/3);
	return energy(e,z);
    }


    public static double energy(double e,Complex[] z) {
    Vector[] V=toVector(z);
	return energy(e,V);
    }

    public static Vector[] toVector(Complex[] z) {
	Vector[] V=new Vector[5];
	for(int i=0;i<4;++i) V[i]=Vector.inverseStereo(z[i]);
	V[4]=new Vector(0,0,1);
	return V;
    }

    public static double energy(double e,Vector[] V) {
	double total=0;
	for(int i=0;i<5;++i) {
	    for(int j=i+1;j<5;++j) {
		total=total+interaction(e,V[i],V[j]);
	    }
	}
	return(total);
    }
    public static double interaction(double e,Vector V1,Vector V2) {
	double d=Vector.distSquared(V1,V2);
	d=Math.pow(d,-e/2);
	return(d);
    }

}


    
