import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

/**This is the wrapper class for the configuration of boxes */

public class Block {
    Box[] B=new Box[5];

    public Block() {}

    /**This returns the list of centers of the boxes**/

    public static Complex[] centerDisplay(Block Y) {
	Complex[] Z=new Complex[4];
	for(int i=0;i<4;++i) Z[i]=new Complex(Y.B[i].z);
        return(Z);
    }

    /**prints out the box**/

    public void print() {
	System.out.println("");
	for(int i=0;i<4;++i) B[i].print();
    }

    /**This copies a box configuration**/

    public Block(Block Y) {
	for(int i=0;i<5;++i) this.B[i]=new Box(Y.B[i]);
    }


    /**The initial box for our proof**/

    public static Block initialBox() {
	Block X=new Block();
	X.B[0]=initialBox1();
	X.B[1]=initialBox0();
	X.B[2]=initialBox0();
	X.B[3]=initialBox0();
	X.B[4]=initialBox2();
	return(X);
    }


    /**The square [-2,2] x [-2,2] **/
    public static Box initialBox0() {
	Box B=new Box(new Complex(0,0),-2,0);
	B.g=new GaussianInteger();
	return(B);
    }

    /**The line segment [0,4].  In this routine, the center is at (2,0),
         but the Gaussian integer tag is obtained by taking this value
         and multiplying by 2^{SCALE}**/

    public static Box initialBox1() {
	Box B=new Box(new Complex(2,0),-2,1);
	B.g.x=(long)(Math.pow(2,1+Box.SCALE));
	B.g.y=0;
        return(B);
    }

    /**The infinite box**/

    public static Box initialBox2() {
	Box B=new Box(new Complex(0,0),0,2);    
        B.g=new GaussianInteger();
        return(B);
    }


    /**Subdivides one of the square components in quarters**/

    public Block subdivide0(int choice,int n) {
	Block X=new Block(this);
	X.B[choice]=B[choice].subdivide0(n);
	     for(int i=0;i<4;++i) {
	           if(i!=choice)    X.B[i]=new Box(B[i]);
	     }
	return(X);
    }


    /**subdivides the segment factor in half**/

    public Block subdivide1(int n) {	
	Block X=new Block(this);
	X.B[0]=B[0].subdivide1(n);
        X.B[1]=new Box(B[1]);
        X.B[2]=new Box(B[2]);
        X.B[3]=new Box(B[3]);    
	return(X);
    }

    /**This is the exponent e such that the volume of the
       configuration is 
                          (1/2)^e

       The entire configuration has volume (1/2)^{-14}=2^{14}
    */

    public int volumeLog() {
	int log = 1*B[0].k+2*B[1].k+2*B[2].k+2*B[3].k;
	return(log);
    }

    public int maxDepth() {
	int depth=-2;
	for(int i=0;i<4;++i) {
	    if(depth<B[i].k) depth=B[i].k;
	}
	depth=depth+2;
	return depth;
    }


}
