import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

/**This class does the basic arithmetic of complex numbers */

public class Complex {
    double x,y;
    

    /**constructors **/

    public Complex() {
        this.x=0.0;
        this.y=0.0;
    } 

    public Complex(double x,double y) {
        this.x=x;
        this.y=y;
    }

    public Complex(Complex z) {
        this.x=z.x;
        this.y=z.y;
    }


    /**printout**/
     public void print() {
 	System.out.println("Complex: "+this.x+" "+this.y);
    } 

    public static Complex plus(Complex z1,Complex z2) {
        return new Complex(z1.x+z2.x, z1.y+z2.y);
    }

    public static Complex minus(Complex z1,Complex z2) {
        return new Complex(z1.x-z2.x, z1.y-z2.y);
    }

    public static Complex average(Complex z1,Complex z2) {
        return new Complex(.5*z1.x+.5*z2.x, .5*z1.y+.5*z2.y);
    }

    public static double dist(Complex a,Complex b) {
        Complex z=minus(a,b);
	return Math.sqrt(z.x*z.x+z.y*z.y);
    }

    public double norm() {
	Complex z=new Complex(0,0);
	return dist(z,this);
    }

    public Complex makeDyadic(int k) {
	double d=Math.pow(2.0,k);
	double a=Math.floor(d*x);
	a=a/d+.5/d;
	double b=Math.floor(d*y);
	b=b/d+.5/d;
	return(new Complex(a,b));
    }


}

