import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class ControlCanvas extends ScaleCanvas implements MouseListener,KeyListener {
    Manager M;
    ControlPanel MAIN,PROOFMODE,DEBUG,SIMPLE;
    Parameter[][] ENERGY=new Parameter[3][2];
    SelectInteger ENERGY1,ENERGY2;
    Parameter TOL,SCALE;
    Proof PROOF;    
    ProofMonitor PC;
    ListenSquare GO,HALT;     
    PopupManager PM;
    ListenSquare[] INFO=new ListenSquare[2];
    Lever SPEED;



     public ControlCanvas() {
	 addMouseListener(this);
	 addKeyListener(this);
	 ControlPanelSetup.main(this);
         setButtons();
	 PM=new PopupManager(null,181,0);
         PROOF=new Proof();   
	 PC=new ProofMonitor(260,0);
	 SPEED=new Lever(100,210,0,20);

	 String[][] c1={{"1","10"},{"28","5"},{"102","2"}};

	 for(int i=0;i<3;++i) {
	    ENERGY[i][0]=new Parameter(243+100*i,153,52,c1[i][0]);
	    ENERGY[i][1]=new Parameter(290+100*i,153,25,c1[i][1]);
	 }
	 ENERGY1=new SelectInteger(157,153,40,20,3,3,6,1);
	 ENERGY2=new SelectInteger(157,153,40,20,7,3,7,1);
	 TOL=new Parameter(100,180,25,"18");
	 SCALE=new Parameter(198,180,25,"30");
	 INFO[0]=new ListenSquare(249,0,12,12);
	 INFO[1]=new ListenSquare(542,0,12,12);
     }

    public void setButtons() {
	GO=new ListenSquare(0,147,25,20,Color.red); GO.on=1;
	HALT=new ListenSquare(0,214,35,20,Color.red); HALT.on=1;	
    }


   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      makeFrame(g);
      g.setFont(new Font("Helvetica",Font.PLAIN,12));
      drawPanels(g);    
      drawButtons(g);
      PM.render(g); 
      INFO[0].infoRender(g);
      INFO[1].infoRender(g);   	  
   }

    public void makeFrame(Graphics2D g) {
    g.setColor(new Color(100,0,160));
      g.fillRect(0,0,getWidth(),getHeight()); 
    

    }

    public void drawButtons(Graphics2D g) {
      g.setFont(new Font("Helvetica",Font.PLAIN,12));
      if(PROOF.HALT==true) { 
          GO.render(g,new Color(0,180,0));
          g.drawString("go",(int)(GO.x+5),(int)(GO.y+15));
      }
      if(PROOF.HALT==false)     {
	  HALT.render(g,new Color(220,0,0));
          g.drawString("stop",(int)(HALT.x+5),(int)(HALT.y+15));

      }
   
    }

    public void drawPanels(Graphics2D g) {
       MAIN.render(g,0,0,85);
       SIMPLE.render(g,90,0,85);
       if(MAIN.mode==0) PROOFMODE.render(g,0,55,85);
       if(MAIN.mode==1) DEBUG.render(g,getWidth()-166,0,165);
       g.setColor(new Color(55,100,255));
       g.fillRect(0,147,getWidth()-1,87);
       g.setColor(Color.white);
       g.drawRect(0,147,getWidth()-1,87);
       if(MAIN.mode==0) PC.render(g);
       if(SIMPLE.mode==0) drawPanelsSimple(g);
       if(SIMPLE.mode==1) drawPanelsAdvanced(g);
    }


  public void drawPanelsSimple(Graphics2D g) {
      ENERGY1.render(g,Color.blue,Color.white,Color.white);
       g.setColor(Color.white);   
       g.setFont(new Font("Helvetica",Font.PLAIN,16));
       g.drawString("energy",45,169);
       g.drawString("radius: (15)",45,195);
       g.drawString("depth: 25",150,195);
  }

  public void drawPanelsAdvanced(Graphics2D g) {
      ENERGY2.render(g,Color.blue,Color.white,new Color(0,0,0,0));
       g.setColor(Color.white);	
       g.setFont(new Font("Helvetica",Font.PLAIN,16));
       g.drawString("energy ",45,169);
       g.drawString("+",261,168);
       g.drawString("+",391,168);
       for(int i=0;i<3;++i) {
	   for(int j=0;j<2;++j) {
	       ENERGY[i][j].render(g);
	   }
       }
       TOL.render(g);
       SCALE.render(g);	
       g.setFont(new Font("Helvetica",Font.PLAIN,16));
       g.drawString("radius",45,TOL.y+15);
       g.drawString("depth:",SCALE.x-48,SCALE.y+15);
       SPEED.render(g,"",new Color(0,0,200));
       g.drawString("speed",45,225);
  }



  public void updatePanels(Point X) { 
      if(PROOF.HALT==false) return;  
      if(MAIN.mode==0) PROOFMODE.switchMode(X);
      if(MAIN.mode==1) DEBUG.switchMode(X); 
      MAIN.switchMode(X);
      SIMPLE.switchMode(X);
  }





     public void doRun() {
	 if(MAIN.mode==0) doRunProof();
	 if(MAIN.mode==1) doRunDebug();
     }


     public void doRunProof() {
	 if(PROOF.HALT==true) {
             PROOF=new Proof(this.M);
	     new Thread(PROOF).start();
	}
    }

     public void doRunDebug() {
	 Debug.run(DEBUG.mode,M);
    }


    public void doStop() {
	PROOF.HALT=true;
    }

  public void documentStuff(Point X) {
        if(PROOFMODE.L[20].inside(X)==1) DocumentControl.proofmode(M.D);
        if(SIMPLE.L[20].inside(X)==1) DocumentControl.advanced(M.D);
        if(MAIN.L[20].inside(X)==1) DocumentControl.action(M.D);
	if(DEBUG.L[20].inside(X)==1) DocumentControl.debugmode(M.D);
	if(INFO[1].inside(X)==1) DocumentControl.monitor(M.D);
	if(INFO[0].inside(X)==1) DocumentControl.popups(M.D);
    }

    public void setEnergyAdvanced(MouseEvent e) {
      for(int i=0;i<3;++i) {
	 for(int j=0;j<2;++j) {
	    ENERGY[i][j].process(e);
	 }
      }   
      MouseData J=MouseData.process(e);
      ENERGY2.modify(J.X);
      if(ENERGY2.isModified(J.X)==1) {
	  Integer t=new Integer(ENERGY2.val);

          if(t<=6) {
	     ENERGY[0][0].S="1";
	     ENERGY[0][1].S=t.toString();
	     ENERGY[1][0].S="0";
	     ENERGY[1][1].S="1";
	     ENERGY[2][0].S="0";
	     ENERGY[2][1].S="1";
          }  
          if(t==7) {
	     ENERGY[0][0].S="1";
	     ENERGY[0][1].S="10";
	     ENERGY[1][0].S="28";
	     ENERGY[1][1].S="5";
	     ENERGY[2][0].S="102";
	     ENERGY[2][1].S="2";
          }
      }
    }
    
    public void mouseClicked(MouseEvent e) { 
	PM.M=this.M;
        MouseData J=MouseData.process(e);
	PM.process(J.X);
        updatePanels(J.X); 
	documentStuff(J.X);
        if(GO.inside(J.X)==1) doRun();
        if(HALT.inside(J.X)==1) doStop();
	if(SIMPLE.mode==0) ENERGY1.modify(J.X);
	if(SIMPLE.mode==1) setEnergyAdvanced(e);
	TOL.process(e);
	SCALE.process(e);
	SPEED.process(J.X);

	//doTest();
        M.repaint();
    }

    public void doTest() {}



    public void mousePressed(MouseEvent e) {}
     public void mouseReleased(MouseEvent e) {}
     public void mouseEntered(MouseEvent e) {
	 requestFocus();
     }
     public void mouseExited(MouseEvent e) {}   

    public void keyTyped(KeyEvent e) {

	if(SIMPLE.mode==0) return;

	for(int i=0;i<3;++i) {
	   ENERGY[i][0].processKey(false,e);
	   ENERGY[i][1].processKey(true,e);
	}
	SCALE.processKey(true,e);
	TOL.processKey(true,e);
	Box.TOL=TOL.getVal();
	Box.SCALE=SCALE.getVal();
	M.repaint();
    }
 
    public void keyPressed(KeyEvent e) {}
    public void keyReleased(KeyEvent e) {}



}

