import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

/**This is part of the debugging apparatus for the program.
   It brings up the grader window.  The grader subjects the
   current block to the grading step of the algorithm.  The
   current block is the one displayed in the block window.*/

public class GraderCanvas extends ScaleCanvas implements MouseListener {
    Manager M;
    String[] S=new String[20];
    String[] T=new String[20];
    int FAIL;
    boolean PASS;
    ListenSquare INFO=new ListenSquare();

     public GraderCanvas() {
	 addMouseListener(this);
	 setStrings();
	 INFO=new ListenSquare(387,0,12,12);
     }


    /**Sets up the text for the window.*/

    public void setStrings() {
	for(int i=0;i<15;++i) S[i]="";
	for(int i=0;i<15;++i) T[i]="";
	S[0]="small enough";
	S[1]="irrelevant";
	S[2]="too far out";
	S[3]="too near TBP";
	S[4]="energy theorem";
	S[5]="min vtx energy";
	S[6]="error term 3";
	S[7]="error term 2";
	S[8]="error term 1";
	S[9]="error term 0";
	S[10]="total error";
	S[11]="lower bound";
	S[12]="TBP energy";


    }


    /**Paint method*/

   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);
      try {getResults();}
      catch(Exception e) {}
      drawText(g);

  }


    /**draws the background*/
    public void drawBG(Graphics2D g) {
	g.setColor(new Color(200,0,200));
	g.fillRect(0,0,getWidth(),getHeight());
	g.setColor(new Color(0,0,255));
	g.fillRect(0,0,getWidth(),122);
	g.setColor(Color.black);
	g.fillRect(160,0,getWidth()-130,getHeight());
	g.setColor(new Color(0,30,50));
	g.fillRect(160,122,getWidth()-130,getHeight()-130);

    }



    /**Draws the text*/

    public void drawText(Graphics2D g) {
       g.setFont(new Font("Helvetica",Font.PLAIN,20));
       g.setColor(Color.white);
       for(int i=0;i<13;++i) {
	   g.drawString(S[i],5,20+30*i);
       }
       for(int i=0;i<13;++i) {
	   if(i==9) g.setColor(new Color(0,255,0));
	   if(i==8) g.setColor(new Color(255,0,255));
	   if(i==7) g.setColor(new Color(255,0,0));
	   if(i==6) g.setColor(new Color(255,150,0));
	   if(i==5) g.setColor(new Color(255,255,180));
	   if(i==10) g.setColor(new Color(255,255,180));
	   if(i==11) g.setColor(new Color(255,255,180));
	   g.drawString(T[i],180,20+30*i);
	   g.setColor(Color.white);
       }
       Color[] COL=Configuration.colors();
       if(PASS==false) {
            g.setColor(COL[FAIL]);
            g.fillRect(289,55,50,50);
       }
       INFO.infoRender(g);
    }


    /**Here is the long routine that does the grading
       step and reports back the results.*/

    public void getResults() {

	PASS=false;
	for(int i=0;i<13;++i) T[i]="";

	Block X=M.P.getBlock();
	int mode=M.C.PROOFMODE.mode;
	int[][] E=new int[3][2];
	for(int i=0;i<3;++i) {
	    for(int j=0;j<2;++j) {
		E[i][j]=M.C.ENERGY[i][j].getVal();
	    }
	}

	  int s=sideTooLong(X);
	  if(s==-1) T[0]="yes";
	  if(s!=-1) {
	      Integer S=new Integer(s);
	      T[0]="fail "+S.toString();
	      FAIL=s;
	      PASS=false;
	      return;
	  }

	  boolean test=EliminatePermuted.main(X);
	  if(test==true) {
	      T[1]="pass";
	      PASS=true;
	      return;
	  }

	  if(test==false) {
	      T[1]="---";
	  }

	  test=EliminateFarOut.main(X);
	  if(test==true) {
	      T[2]="pass";  
              PASS=true;
	      return;
	  }

	  if(test==false) {
	      T[2]="---";
	  }

	  test=EliminateNearTBP.main(X);
	  if(test==true) {
	      T[3]="pass";  
              PASS=true;
	      return;
	  }

	  if(test==false) {
	      T[3]="---";
	  }


          int[] test2=EliminateEnergy.main(E,X);

	  if(test2[0]==1) {
	      T[4]="pass";  
              PASS=true;
	  }

         if(test2[0]==0) {
	     Integer I=new Integer(test2[1]);
	     T[4]="fail "+I.toString(); 
             FAIL=test2[1];   
             PASS=false;
	 }


	 double d=EliminateEnergy.minVertexEnergy(E,X);
	 Double D=new Double(d);
	 T[5]=D.toString();

	 double tot=0;
	 for(int i=0;i<4;++i) {
	     d=EliminateEnergy.ERR(E,X,i);
	     tot=tot+d;
	     D=new Double(d);
	     T[9-i]=D.toString();
	 }

	 double[] dd=EliminateEnergy.ERR(E,X); 
         D=new Double(dd[0]);
	 T[10]=D.toString();

	 d=EliminateEnergy.minVertexEnergy(E,X)-tot;
         D=new Double(d);
	 T[11]=D.toString();


	 d=EliminateEnergy.TBPenergy(E);
	 D=new Double(d);
	 T[12]=D.toString();


    }


    /**this is part of the grading step*/

    public static int sideTooLong(Block X) {
	for(int i=1;i<4;++i) {
            if(X.B[i].k<1) return(i);
	}
	return -1;
    }

    /**Mouse events*/

    public void mouseClicked(MouseEvent e) {
        MouseData J=MouseData.process(e);
	if(INFO.inside(J.X)==1) DocumentBlock.grader(M.D);
	M.repaint();
    }

    public void mousePressed(MouseEvent e) {}
     public void mouseReleased(MouseEvent e) {}
     public void mouseEntered(MouseEvent e) {
     }
     public void mouseExited(MouseEvent e) {}   
     public void mouseDragged(MouseEvent e) {
     } 

     public void mouseMoved(MouseEvent e) {
     }

}

