import java.awt.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;



public class GridDrawer {

    /**This draws the grid for the picture window*/

    public static void drawGrid(PictureCanvas P,Graphics2D g,int t) {

	int s=t-5;
	Color[] C={new Color(0,0,150),
                   new Color(0,0,190),
                   new Color(0,0,220),
                   new Color(0,0,250),
                   new Color(20,40,250),
                   new Color(40,100,255),
                   new Color(50,120,255)};
	Color CC=Color.orange;
	for(int i=5;i>-2;--i) {
	    if(i<=t) CC=C[5-i+s];
	    if(i<=t) drawGrid(P,g,i,1,CC);
	}
    }



    public static void drawGrid(PictureCanvas P,Graphics2D g,int k, double thick,Color C) {
	Path2D.Double gp=new Path2D.Double();
	double d0=Math.pow(2,k);
	double d1=d0;

	for(int i=(int)(-2*d1);i<=2*d1;++i) {
	    float x=(float)(1.0*i/d0);
	    float y1=(float)(-2);
	    float y2=-y1;
	    gp.moveTo(x,y1);
	    gp.lineTo(x,y2);
	}

	for(int i=(int)(-2*d1);i<=2*d1;++i) {
	    float y=(float)(1.0*i/d0);
	    gp.moveTo(-2,y);
	    gp.lineTo(2,y);
	}

	g.setStroke(new BasicStroke((float)(thick)));
	gp=P.transform(gp);
	g.setColor(C);
	g.draw(gp);	
	g.setStroke(new BasicStroke(1));
    }



    /**Here is the unit circle**/
    public static void drawTriangle(PictureCanvas P,Graphics2D g) {

	double Pi=Math.PI;
	Path2D.Double gp=new Path2D.Double();

	gp.reset();	
        gp.moveTo(1,0);
	for(int i=0;i<3;++i) {
	    double t=1.0*i;
	    double c=Math.cos(2*Pi*t/3);
	    double s=Math.sin(2*Pi*t/3);
	    gp.lineTo(c,s);
	}
	gp.closePath();
	for(int i=0;i<3;++i) {
	    double t=1.0*i;
	    double c=Math.cos(2*Pi*t/3);
	    double s=Math.sin(2*Pi*t/3);
	    gp.moveTo(0,0);
	    gp.lineTo(c,s);
	}

	g.setColor(new Color(140,0,250));
	gp=P.transform(gp);
	g.setStroke(new BasicStroke(2));
	g.draw(gp);
	g.setStroke(new BasicStroke(1));

    }


    public static void drawTriangleOpposite(PictureCanvas P,Graphics2D g) {

	double Pi=Math.PI;
	Path2D.Double gp=new Path2D.Double();

	gp.reset();	
        gp.moveTo(-1,0);
	for(int i=0;i<3;++i) {
	    double t=1.0*i;
	    double c=Math.cos(2*Pi*t/3);
	    double s=Math.sin(2*Pi*t/3);
	    gp.lineTo(-c,-s);
	}
	g.setColor(new Color(110,0,220,200));
	gp.closePath();
	gp=P.transform(gp);
	g.draw(gp);

    }




}
