import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.math.*;


public class Interval {
    double l,r;

    /**constructors **/

    public Interval() { }

    public Interval(Interval X) {
	this.l=X.l;
	this.r=X.r;
    }

    public Interval(double x) {
	this.l=x;
	this.r=x;
    }


    /**x<=y in this case**/
    public Interval(double x,double y) {
	this.l=x;
	this.r=y;
    }

    /**printout**/

    public void print() {
	System.out.println("["+this.l+" , "+this.r+"]");
    }

    /**rounds a double upwards **/
  public static double roundUp(double x) {
    if(x==Double.POSITIVE_INFINITY) return(Double.POSITIVE_INFINITY);
    if(x==Double.NEGATIVE_INFINITY) return(Double.NEGATIVE_INFINITY);
    if(x==0)      return Double.longBitsToDouble(1);
    long xx = Double.doubleToLongBits(x);
    if(x>0) return(Double.longBitsToDouble(xx+1));
    return(Double.longBitsToDouble(xx-1));
  }

    /**rounds downward**/
  public static double roundDn(double x) {
      if (x==0) return(-roundUp(0.0));
      return(-roundUp(-x));
  }


    /**round out**/


    public static Interval fat(BigInteger a) {
        BigInteger MAX=new BigInteger("1125899906842624");
        BigInteger MIN=new BigInteger("-1125899906842624");
	if(a.compareTo(MIN)==-1) throw new ProofException("fat: out of range");
	if(a.compareTo(MAX)==+1) throw new ProofException("fat: out of range");
	long x=a.longValue();
	Interval I=new Interval();
	I.l=roundDn(x);
	I.r=roundUp(x);
	return(I);
    }

    public static Interval fat(double x) {
	Interval I=new Interval();
	I.l=roundDn(x);
	I.r=roundUp(x);
	return(I);
    }



    /**basic arithmetic routines**/

    public static Interval max(Interval I,Interval J) {
	double t1=Math.max(I.l,J.l);
	double t2=Math.max(I.r,J.r);
	return(new Interval(t1,t2));
    }

    public static Interval min(Interval I,Interval J) {
	double t1=Math.min(I.l,J.l);
	double t2=Math.min(I.r,J.r);
	return(new Interval(t1,t2));
    }

    public static Interval plus(Interval I,Interval J) {
	checkRangePlusMinus(I,J);
	Interval K=new Interval();
	K.l=roundDn(I.l+J.l);
	K.r=roundUp(I.r+J.r);
	return(K);
    }

    public static Interval minus(Interval I,Interval J) {
	checkRangePlusMinus(I,J);
	Interval K=new Interval();
	K.l=roundDn(I.l-J.r);
	K.r=roundUp(I.r-J.l);
	return(K);
    }

    public static Interval times(Interval I,Interval J) throws ProofException {
	checkRangeTimes(I,J);
	Interval K=new Interval();
        double ll,lr,rl,rr,l,r;
        ll=I.l*J.l;
        lr=I.l*J.r;
        rl=I.r*J.l;
        rr=I.r*J.r;
        K.l=ll;
        if(K.l>lr) K.l=lr;
        if(K.l>rl) K.l=rl;
        if(K.l>rr) K.l=rr;
        K.r=ll;
        if(K.r<lr) K.r=lr;
        if(K.r<rl) K.r=rl;
        if(K.r<rr) K.r=rr;
	K.l=roundDn(K.l);
	K.r=roundUp(K.r);
	return(K);
    }

    public static Interval pow(Interval I,int k) {
	Interval J=new Interval(1.0,1.0);
	for(int i=0;i<k;++i) J=Interval.times(I,J);
	return J;
    }


    /**We only divide by numbers between 1/2048 and 128**/

    public  static Interval divide(Interval I,Interval J) throws ProofException {
	checkRangeDivide(I,J);
	Interval K=new Interval();	
        double ll,lr,rl,rr,l,r;
        ll=I.l/J.l;
        lr=I.l/J.r;
        rl=I.r/J.l;
        rr=I.r/J.r;
        K.l=ll;
        if(K.l>lr) K.l=lr;
        if(K.l>rl) K.l=rl;
        if(K.l>rr) K.l=rr;
        K.r=ll;
        if(K.r<lr) K.r=lr;
        if(K.r<rl) K.r=rl;
        if(K.r<rr) K.r=rr;
        K.l=roundDn(K.l);
	K.r=roundUp(K.r);	
	return(K);
    }



    /**absolute value**/

    public boolean equalsZero() {
	if(l!=0.0) return(false);
	if(r!=0.0) return(false);
	return(true);
    }

    public static  Interval ZERO() {
	return(new Interval(0.0));
    }



    public static void checkRangeTimes(Interval I,Interval J) {
	boolean test1=true;
	double LIMIT1=Math.pow(2,40);
	double LIMIT2=Math.pow(2,10);
	if(I.r>+LIMIT1) test1=false;
	if(I.l<-LIMIT1) test1=false;
	if(J.r>LIMIT2) test1=false;
	if(J.l<-LIMIT2) test1=false;
	if(test1==true) return;
	boolean test2=true;
	if(J.r>+LIMIT1) test2=false;
	if(J.l<-LIMIT1) test2=false;
	if(I.r>LIMIT2) test2=false;
	if(I.l<-LIMIT2) test2=false;
	if(test2==true) return;
	I.print();
	J.print();
        throw new ProofException("bad multiplication");
    }

    public static void checkRangeDivide(Interval I,Interval J) {
	boolean test=true;
	double LIMIT1=Math.pow(2,40);
	double LIMIT2=Math.pow(2,10);
	double LIMIT3=Math.pow(0.5,10);
	if(I.r>+LIMIT1) test=false;
	if(I.l<-LIMIT1) test=false;
	if(J.r>LIMIT2) test=false;
	if(J.l<-LIMIT2) test=false;
	if((J.r>-LIMIT3)&&(J.r<LIMIT3)) test=false;
	if((J.l>-LIMIT3)&&(J.l<LIMIT3)) test=false;
	if(test==false) throw new ProofException("bad division");
    }

    public static void checkRangePlusMinus(Interval I,Interval J) {
	double LIMIT=Math.pow(2,40);
	boolean test=true;
	if(I.r>+LIMIT) test=false;
	if(I.l<-LIMIT) test=false;
	if(J.r>+LIMIT) test=false;
	if(J.l<-LIMIT) test=false;
	if(test==false) throw new ProofException("bad addition or subtraction");
    }


    public static Interval rescaledLong(long a) {
	int S=Box.SCALE;
	Interval SCALE=Interval.inversePower2(S);
	Interval x=Interval.fat(a);
	x=Interval.times(x,SCALE);
	return x;
    }


    public static Interval inversePower2(int k) {
	return fat(Math.pow(0.5,k));
    }



}

