import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

/**This class specifies some basic kinds of point configurations.  It is not
   used in the proof.*/

public class Configuration  {

    /**This is the preferred normalization of the triangular bipyramid*/

    public static Complex[] configuration1() {	
	Complex[] W=new Complex[4];
	W[0]=new Complex(1,0);      	
        W[1]=new Complex(-.5,-Math.sqrt(3.0)/2.0); 
        W[2]=new Complex(0,0);
	W[3]=new Complex(-.5,Math.sqrt(3.0)/2.0);
	return(W);
    }

    /**This is the other normalization of the triangular bipyramid*/

    public static Complex[] configuration2() {	
        Complex[] W=new Complex[4];	
        W[0]=new Complex(1,0);		
        W[1]=new Complex(0,-Math.sqrt(1.0/3.0));
        W[2]=new Complex(-1,0);	
	W[3]=new Complex(0,Math.sqrt(1.0/3.0));
        return(W);
    }

    /**random configuration**/
    public static Complex[] randomPoints() {

	Complex[] Z=new Complex[4];
	for(int i=0;i<4;++i) {
	    double x=Math.random();
	    double y=Math.random();
	    double xx=x*(-2)+(1-x)*2;
	    double yy=y*(-2)+(1-y)*2;
	    Z[i]=new Complex(xx,yy);
	}

	Z[0]=new Complex(1+Math.random(),0);
	return(Z);
    }




    /**The color scheme**/

    public static Color[] colors() {
	Color[] C={new Color(0,220,0),new Color(255,0,255),new Color(200,0,0),new Color(240,130,0)};
	return(C);
    }

}

