import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class EliminateNearFP {

    public static boolean main(Block X) {
	if(inBox(0,X.B[0],Box.SCALE)==false) return false;
	if(inBox(1,X.B[1],Box.SCALE)==false) return false;
	if(inBox(2,X.B[2],Box.SCALE)==false) return false;
	if(inBox(3,X.B[3],Box.SCALE)==false) return false;
	return true;
    }


    public static boolean inBox(int j,Box B,int scale) {
	GaussianInteger[] z=B.toGaussianVertices();
	for(int i=0;i<z.length;++i) {
	    if(inBox(j,z[i],scale)==false) return false;
	}
	return true;
    }

    /**This tests whether the complex number represented
       by the Gaussian integer is contained in the jth
       factor of the special neighborhood of the TBP.*/

    public static boolean inBox(int j,GaussianInteger z,int scale) {
	if(j==0) return inBox0(z,scale);
	if(j==1) return inBox1(z,scale);
	if(j==2) return inBox2(z,scale);
	if(j==3) return inBox3(z,scale);
	return false;
    }

    /**q should be a smallish power of 2*/
    public static long scaleNum(long p,long q,long scale) {
	long x=(long)(1.0*p*Math.pow(2,scale)/q);
	return x;
    }


    public static boolean inBox0(GaussianInteger g,int scale) {	
        long x0=scaleNum(27,32,scale);
        long x1=scaleNum(63,64,scale);	
        if(g.x<x0) return false;
	if(g.x>x1) return false;
	return true;
    }

    public static boolean inBox1(GaussianInteger g,int scale) {	
        long x0=scaleNum(-1,32,scale);
        long x1=scaleNum(+1,32,scale);	 
        long y0=scaleNum(-29,32,scale);
        long y1=scaleNum(-21,32,scale);	
        if(g.y<y0) return false;
	if(g.y>y1) return false;	
        if(g.x<x0) return false;
	if(g.x>x1) return false;
	return true;
    }

    public static boolean inBox2(GaussianInteger g,int scale) {	
        long x0=scaleNum(-63,64,scale);
        long x1=scaleNum(-25,32,scale);	
        long y0=scaleNum(0,1,scale);
        long y1=scaleNum(3,64,scale);		
        if(g.x<x0) return false;
	if(g.x>x1) return false;		
        if(g.y<y0) return false;
	if(g.y>y1) return false;
	return true;
    }

    public static boolean inBox3(GaussianInteger g,int scale) {	
        long x0=scaleNum(-1,32,scale);
        long x1=scaleNum(+1,32,scale);
        if(g.x<x0) return false;
	if(g.x>x1) return false; 
        long y0=scaleNum(21,32,scale);
        long y1=scaleNum(29,32,scale);
	if(g.y<y0) return false;	
	if(g.y>y1) return false;		
	return true;
    }

    public static boolean insideCircle(GaussianInteger g,long p,long q,long scale) {
	long r=scaleNum(p,q,scale);
	long s=g.x*g.x+g.y*g.y;
	if(s<r*r) return true;
	return false;
    }

    public static boolean outsideCircle(GaussianInteger g,long p,long q,long scale) {
	long r=scaleNum(p,q,scale);
	long s=g.x*g.x+g.y*g.y;
	if(s>r*r) return true;
	return false;
    }




}
